/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images;

public class TilePositionInPyramid {
    private final int mLayer;
    private final TilePositionInLayer mPositionInLayer;

    public TilePositionInPyramid(int layer, int row, int column) {
        this(layer, new TilePositionInLayer(row, column));
    }

    public TilePositionInPyramid(int layer, TilePositionInLayer position) {
        this.mLayer = layer;
        this.mPositionInLayer = position;
    }

    public static TilePositionInPyramid valueOf(String string2) {
        String[] tokens = string2.split(":");
        int position = 0;
        int layer = Integer.valueOf(tokens[position++]);
        int x = Integer.valueOf(tokens[position++]);
        int y = Integer.valueOf(tokens[position++]);
        return new TilePositionInPyramid(layer, x, y);
    }

    public String toString() {
        return "" + this.mLayer + ':' + this.mPositionInLayer.column + ':' + this.mPositionInLayer.row;
    }

    public int getLayer() {
        return this.mLayer;
    }

    public TilePositionInLayer getPositionInLayer() {
        return this.mPositionInLayer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mLayer;
        result = 31 * result + this.mPositionInLayer.column;
        result = 31 * result + this.mPositionInLayer.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TilePositionInPyramid other = (TilePositionInPyramid)obj;
        if (this.mLayer != other.mLayer) {
            return false;
        }
        if (this.mPositionInLayer.column != other.getPositionInLayer().column) {
            return false;
        }
        return this.mPositionInLayer.row == other.getPositionInLayer().row;
    }

    public static class TilePositionInLayer {
        public final int column;
        public final int row;

        public TilePositionInLayer(int column, int row) {
            this.column = column;
            this.row = row;
        }
    }
}

