/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.gestures;

import android.os.Handler;
import android.os.Message;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.PointD;
import cz.mzk.tiledimageview.TiledImageViewApi;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.VectorD;
import cz.mzk.tiledimageview.dev.DevTools;
import cz.mzk.tiledimageview.gestures.GestureHandler;

public class FlingShiftHandler
extends Handler {
    public static final long ANIM_STEP_MS = 30L;
    public static final float MIN_VELOCITY_PX_P_S = 10.0f;
    public static final float VELOCITY_PRESERVATION_FACTOR = 0.9f;
    private static final Logger LOGGER = new Logger(FlingShiftHandler.class);
    private final TiledImageViewApi mImageViewApi;
    private final GestureHandler mAbstractGestureHandler;
    private State mState = State.IDLE;
    private VectorD mAccumulatedShift = VectorD.ZERO_VECTOR;
    private Thread mWorkerThread;
    private int mCorrectWorkerId = 0;
    private PointD mInitialFocusInImg;
    private float mVelocityX;
    private float mVelocityY;

    public FlingShiftHandler(TiledImageViewApi imageViewApi, DevTools devTools) {
        this.mImageViewApi = imageViewApi;
        this.mAbstractGestureHandler = new GestureHandler(imageViewApi, devTools);
    }

    public VectorD getShift() {
        return this.mAccumulatedShift;
    }

    public void fling(float downX, float downY, float velocityX, float velocityY) {
        this.mState = State.SHIFTING;
        LOGGER.i(this.mState.name());
        this.mVelocityX = velocityX;
        this.mVelocityY = velocityY;
        this.mInitialFocusInImg = Utils.toImageCoords(new PointD(downX, downY), this.mImageViewApi.getTotalScaleFactor(), this.mImageViewApi.getTotalShift());
        this.mWorkerThread = new Thread(new AnimationRunnable(this, this.mCorrectWorkerId));
        this.mWorkerThread.start();
    }

    public void handleMessage(Message msg) {
        switch (this.mState) {
            case SHIFTING: {
                int workerId = msg.arg1;
                if (workerId == this.mCorrectWorkerId) {
                    boolean keepMoving = this.shift();
                    if (keepMoving) {
                        this.updateVelocities();
                        break;
                    }
                    LOGGER.v(String.format("ui thread: message from thread %d - ignoring (velocities to low)", workerId));
                    this.stopAnimation();
                    break;
                }
                LOGGER.v(String.format("ui thread: message from thread %d - ignoring (old threadead)", workerId));
                break;
            }
            case IDLE: {
                LOGGER.v(String.format("ui thread: message from thread %d - ignoring (mState IDLE)", msg.arg1));
            }
        }
    }

    private boolean shift() {
        double totalScaleFactor = this.mImageViewApi.getTotalScaleFactor();
        VectorD totalShift = this.mImageViewApi.getTotalShift();
        float stepSecondFraction = 0.03f;
        float pixelsPerStepX = this.mVelocityX * stepSecondFraction;
        float pixelsPerStepY = this.mVelocityY * stepSecondFraction;
        double pixelsPerStepCanvasX = (double)pixelsPerStepX * totalScaleFactor;
        double pixelsPerStepCanvasY = (double)pixelsPerStepY * totalScaleFactor;
        PointD currentInCanvas = Utils.toCanvasCoords(this.mInitialFocusInImg, totalScaleFactor, totalShift);
        PointD nextInCanvas = currentInCanvas.plus(new VectorD(pixelsPerStepCanvasX, pixelsPerStepCanvasY));
        PointD nextInImg = Utils.toImageCoords(nextInCanvas, totalScaleFactor, totalShift);
        VectorD newShift = this.mAbstractGestureHandler.limitNewShift(this.mInitialFocusInImg.minus(nextInImg));
        LOGGER.v("shift: " + newShift.toString());
        if (newShift.x == 0.0 && newShift.y == 0.0) {
            LOGGER.d("zero shift");
            this.stopAnimation();
        }
        newShift = this.mAbstractGestureHandler.limitNewShift(newShift);
        this.mAccumulatedShift = this.mAccumulatedShift.plus(newShift);
        this.mImageViewApi.invalidate();
        return Math.abs(this.mVelocityX) > 10.0f || Math.abs(this.mVelocityY) > 10.0f;
    }

    private void updateVelocities() {
        this.mVelocityX *= 0.9f;
        this.mVelocityY *= 0.9f;
        LOGGER.v(String.format("velocities: x: %.2f, y: %.2f px/s", Float.valueOf(this.mVelocityX), Float.valueOf(this.mVelocityY)));
    }

    public void reset() {
        LOGGER.d("resetting");
        if (this.mState == State.SHIFTING) {
            LOGGER.w("animation still running");
            this.stopAnimation();
        }
        this.mAccumulatedShift = VectorD.ZERO_VECTOR;
    }

    public State getmState() {
        return this.mState;
    }

    public void stopAnimation() {
        LOGGER.d("stopping animation");
        if (this.mState == State.IDLE) {
            LOGGER.w("already stopped");
        } else {
            if (this.mWorkerThread != null && this.mWorkerThread.isAlive()) {
                this.mWorkerThread.interrupt();
            }
            this.mWorkerThread = null;
            ++this.mCorrectWorkerId;
            LOGGER.v("correct worker id: " + this.mCorrectWorkerId);
            this.mState = State.IDLE;
            LOGGER.i(this.mState.name());
        }
    }

    private class AnimationRunnable
    implements Runnable {
        private final Handler handler;
        private final int workerId;

        public AnimationRunnable(Handler handler, int workerId) {
            this.handler = handler;
            this.workerId = workerId;
        }

        @Override
        public void run() {
            while (true) {
                Message msg = Message.obtain();
                msg.arg1 = this.workerId;
                this.handler.sendMessage(msg);
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    public static enum State {
        IDLE,
        SHIFTING;

    }
}

