/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.gestures;

import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.TiledImageViewApi;
import cz.mzk.tiledimageview.VectorD;
import cz.mzk.tiledimageview.dev.DevTools;
import cz.mzk.tiledimageview.gestures.GestureHandler;

public class DragShiftHandler
extends GestureHandler {
    public static final double MIN_DRAG_DISTANCE_TO_RECOGNIZE_SHIFT_DP = 1.0;
    public static final long MAX_DRAG_TIME_TO_BE_CONSIDERED_SINGLE_TAP_NS = 200000000L;
    public static final double MAX_DRAG_DISTANCE_TO_BE_CONSIDERED_SINGLE_TAP_DP = 10.0;
    private static final Logger LOGGER = new Logger(DragShiftHandler.class);
    private VectorD mAccumulatedShift = VectorD.ZERO_VECTOR;
    private State mState = State.IDLE;

    public DragShiftHandler(TiledImageViewApi imageViewApi, DevTools devTools) {
        super(imageViewApi, devTools);
    }

    public void drag(float shiftX, float shiftY) {
        this.mState = State.SHIFTING;
        LOGGER.i(this.mState.name());
        VectorD shift = this.limitNewShift(new VectorD(shiftX, shiftY));
        this.mAccumulatedShift = this.mAccumulatedShift.plus(shift);
        this.mState = State.IDLE;
        LOGGER.i(this.mState.name());
        this.mImageViewApi.invalidate();
    }

    public State getmState() {
        return this.mState;
    }

    public VectorD getShift() {
        return this.mAccumulatedShift;
    }

    public void reset() {
        LOGGER.d("resetting");
        this.mAccumulatedShift = VectorD.ZERO_VECTOR;
    }

    public static enum State {
        IDLE,
        SHIFTING;

    }
}

