/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.zoomify;

import android.graphics.Rect;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.Point;
import cz.mzk.tiledimageview.TiledImageView;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.images.ImageManager;
import cz.mzk.tiledimageview.images.TileDimensionsInImage;
import cz.mzk.tiledimageview.images.TilePositionInPyramid;
import cz.mzk.tiledimageview.images.TiledImageProtocol;
import cz.mzk.tiledimageview.images.metadata.ImageMetadata;
import cz.mzk.tiledimageview.images.tasks.ImageManagerTaskRegistry;
import cz.mzk.tiledimageview.images.zoomify.Layer;
import java.util.ArrayList;
import java.util.List;

public class ZoomifyImageManager
implements ImageManager {
    public static final boolean COMPUTE_NUMBER_OF_LAYERS_ROUND_CALCULATION = true;
    private static final Logger LOGGER = new Logger(ZoomifyImageManager.class);
    private final ImageManagerTaskRegistry taskRegistry = new ImageManagerTaskRegistry(this);
    private final String mBaseUrl;
    private final double mPxRatio;
    private final String mImagePropertiesUrl;
    private ImageMetadata mImageMetadata;
    private List<Layer> mLayers;

    public ZoomifyImageManager(String zoomifyBaseUrl, double pxRatio) {
        if (pxRatio < 0.0 || pxRatio > 1.0) {
            throw new IllegalArgumentException("pxRation not in <0;1> interval");
        }
        this.mPxRatio = pxRatio;
        if (zoomifyBaseUrl == null || zoomifyBaseUrl.isEmpty()) {
            throw new IllegalArgumentException("baseUrl is null or empty");
        }
        this.mBaseUrl = zoomifyBaseUrl.endsWith("/") ? zoomifyBaseUrl : zoomifyBaseUrl + '/';
        this.mImagePropertiesUrl = this.mBaseUrl + "ImageProperties.xml";
    }

    private void checkInitialized() {
        if (this.mImageMetadata == null) {
            throw new IllegalStateException("not initialized (" + this.mBaseUrl + ")");
        }
    }

    @Override
    public int getImageWidth() {
        this.checkInitialized();
        return this.mImageMetadata.getWidth();
    }

    @Override
    public int getImageHeight() {
        this.checkInitialized();
        return this.mImageMetadata.getHeight();
    }

    @Override
    public int getTileTypicalSize() {
        this.checkInitialized();
        return this.mImageMetadata.getTileSize();
    }

    @Override
    public void init(ImageMetadata imageMetadata) {
        if (this.mImageMetadata != null) {
            throw new IllegalStateException("already initialized (" + this.mImagePropertiesUrl + ")");
        }
        LOGGER.d("initImageMetadata: " + this.mImagePropertiesUrl);
        this.mImageMetadata = imageMetadata;
        LOGGER.d(this.mImageMetadata.toString());
        this.mLayers = this.initLayers();
    }

    @Override
    public void enqueueMetadataInitialization(TiledImageView.MetadataInitializationHandler handler, TiledImageView.MetadataInitializationSuccessListener successListener) {
        this.taskRegistry.enqueueMetadataInitializationTask(this.mImagePropertiesUrl, handler, successListener);
    }

    @Override
    public boolean isInitialized() {
        return this.mImageMetadata != null;
    }

    private List<Layer> initLayers() {
        int numberOfLayers = this.computeNumberOfLayers();
        ArrayList<Layer> result = new ArrayList<Layer>(numberOfLayers);
        double width = this.mImageMetadata.getWidth();
        double height = this.mImageMetadata.getHeight();
        double tileSize = this.mImageMetadata.getTileSize();
        for (int layer = 0; layer < numberOfLayers; ++layer) {
            double powerOf2 = Utils.pow(2, numberOfLayers - layer - 1);
            int tilesHorizontal = (int)Math.ceil(Math.floor(width / powerOf2) / tileSize);
            int tilesVertical = (int)Math.ceil(Math.floor(height / powerOf2) / tileSize);
            result.add(new Layer(tilesVertical, tilesHorizontal));
        }
        return result;
    }

    private int computeNumberOfLayers() {
        float tilesInLayer = -1.0f;
        int tilesInLayerInt = -1;
        float maxDimension = Math.max(this.mImageMetadata.getWidth(), this.mImageMetadata.getHeight());
        float tileSize = this.mImageMetadata.getTileSize();
        int i = 0;
        do {
            tilesInLayer = maxDimension / (tileSize * (float)Utils.pow(2, i));
            ++i;
        } while ((tilesInLayerInt = (int)Math.ceil(Utils.round(tilesInLayer, 3))) != 1);
        return i;
    }

    @Override
    public List<TilePositionInPyramid> getVisibleTilesForLayer(int layerId, Rect visibleAreaInImageCoords) {
        TilePositionInPyramid.TilePositionInLayer[] corners = this.getCornerVisibleTilesCoords(layerId, visibleAreaInImageCoords);
        TilePositionInPyramid.TilePositionInLayer topLeftVisibleTilePositionInLayer = corners[0];
        TilePositionInPyramid.TilePositionInLayer bottomRightVisibleTilePositionInLayer = corners[1];
        ArrayList<TilePositionInPyramid> visibleTiles = new ArrayList<TilePositionInPyramid>();
        for (int y = topLeftVisibleTilePositionInLayer.row; y <= bottomRightVisibleTilePositionInLayer.row; ++y) {
            for (int x = topLeftVisibleTilePositionInLayer.column; x <= bottomRightVisibleTilePositionInLayer.column; ++x) {
                visibleTiles.add(new TilePositionInPyramid(layerId, x, y));
            }
        }
        return visibleTiles;
    }

    private TilePositionInPyramid.TilePositionInLayer[] getCornerVisibleTilesCoords(int layerId, Rect visibleAreaInImageCoords) {
        int imageWidthMinusOne = this.mImageMetadata.getWidth() - 1;
        int imageHeightMinusOne = this.mImageMetadata.getHeight() - 1;
        int topLeftVisibleX = Utils.collapseToInterval(visibleAreaInImageCoords.left, 0, imageWidthMinusOne);
        int topLeftVisibleY = Utils.collapseToInterval(visibleAreaInImageCoords.top, 0, imageHeightMinusOne);
        int bottomRightVisibleX = Utils.collapseToInterval(visibleAreaInImageCoords.right, 0, imageWidthMinusOne);
        int bottomRightVisibleY = Utils.collapseToInterval(visibleAreaInImageCoords.bottom, 0, imageHeightMinusOne);
        Point topLeftVisibleInImageCoords = new Point(topLeftVisibleX, topLeftVisibleY);
        Point bottomRightVisibleInImageCoords = new Point(bottomRightVisibleX, bottomRightVisibleY);
        TilePositionInPyramid.TilePositionInLayer topLeftVisibleTile = this.calculateTileCoordsFromPointInImageCoords(layerId, topLeftVisibleInImageCoords);
        TilePositionInPyramid.TilePositionInLayer bottomRightVisibleTile = this.calculateTileCoordsFromPointInImageCoords(layerId, bottomRightVisibleInImageCoords);
        return new TilePositionInPyramid.TilePositionInLayer[]{topLeftVisibleTile, bottomRightVisibleTile};
    }

    private int computeTileGroup(TilePositionInPyramid tilePositionInPyramid) {
        int column = tilePositionInPyramid.getPositionInLayer().column;
        int row = tilePositionInPyramid.getPositionInLayer().row;
        int level = tilePositionInPyramid.getLayer();
        double tileSize = this.mImageMetadata.getTileSize();
        double width = this.mImageMetadata.getWidth();
        double height = this.mImageMetadata.getHeight();
        double depth = this.mLayers.size();
        double first = Math.ceil(Math.floor(width / Math.pow(2.0, depth - (double)level - 1.0)) / tileSize);
        double index = (double)column + (double)row * first;
        for (int i = 1; i <= level; ++i) {
            index += Math.ceil(Math.floor(width / Math.pow(2.0, depth - (double)i)) / tileSize) * Math.ceil(Math.floor(height / Math.pow(2.0, depth - (double)i)) / tileSize);
        }
        int result = (int)(index / tileSize);
        return result;
    }

    private String buildTileUrl(int tileGroup, TilePositionInPyramid tilePositionInPyramid) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mBaseUrl).append("TileGroup").append(tileGroup).append('/');
        builder.append(tilePositionInPyramid.getLayer()).append('-').append(tilePositionInPyramid.getPositionInLayer().column).append('-').append(tilePositionInPyramid.getPositionInLayer().row).append(".jpg");
        return builder.toString();
    }

    private TilePositionInPyramid.TilePositionInLayer calculateTileCoordsFromPointInImageCoords(int layerId, Point pointInMageCoords) {
        this.checkInitialized();
        if (layerId < 0 || layerId >= this.mLayers.size()) {
            throw new IllegalArgumentException("layer out of range: " + layerId);
        }
        if (pointInMageCoords.x < 0 || pointInMageCoords.x >= this.mImageMetadata.getWidth()) {
            throw new IllegalArgumentException("x coord out of range: " + pointInMageCoords.x);
        }
        if (pointInMageCoords.y < 0 || pointInMageCoords.y >= this.mImageMetadata.getHeight()) {
            throw new IllegalArgumentException("y coord out of range: " + pointInMageCoords.y);
        }
        if (layerId == 0) {
            return new TilePositionInPyramid.TilePositionInLayer(0, 0);
        }
        double step = (double)this.mImageMetadata.getTileSize() * Math.pow(2.0, this.mLayers.size() - layerId - 1);
        double cx_step = (double)pointInMageCoords.x / step;
        int x = (int)Math.floor(cx_step);
        double cy_step = (double)pointInMageCoords.y / step;
        int y = (int)Math.floor(cy_step);
        TilePositionInPyramid.TilePositionInLayer result = new TilePositionInPyramid.TilePositionInLayer(x, y);
        return result;
    }

    @Override
    public int computeBestLayerId(Rect wholeImageInCanvasCoords) {
        this.checkInitialized();
        double dpRatio = 1.0 - this.mPxRatio;
        if (this.mPxRatio < 0.0) {
            throw new IllegalArgumentException("px ratio must be >= 0");
        }
        if (this.mPxRatio > 1.0) {
            throw new IllegalArgumentException("px ratio must be <= 1");
        }
        int imageInCanvasWidthDp = 0;
        int imageInCanvasHeightDp = 0;
        if (this.mPxRatio < 1.0) {
            imageInCanvasWidthDp = Utils.pxToDp(wholeImageInCanvasCoords.width());
            imageInCanvasHeightDp = Utils.pxToDp(wholeImageInCanvasCoords.height());
        }
        int imgInCanvasWidth = (int)((double)imageInCanvasWidthDp * dpRatio + (double)wholeImageInCanvasCoords.width() * this.mPxRatio);
        int imgInCanvasHeight = (int)((double)imageInCanvasHeightDp * dpRatio + (double)wholeImageInCanvasCoords.height() * this.mPxRatio);
        return this.bestLayerAtLeastAsBigAs(imgInCanvasWidth, imgInCanvasHeight);
    }

    private int bestLayerAtLeastAsBigAs(int imgInCanvasWidth, int imageInCanvasHeight) {
        for (int layerId = 0; layerId < this.mLayers.size(); ++layerId) {
            double layerWidth = this.getLayerWidth(layerId);
            double layerHeight = this.getLayerHeight(layerId);
            if (!(layerWidth >= (double)imgInCanvasWidth) || !(layerHeight >= (double)imageInCanvasHeight)) continue;
            return layerId;
        }
        return this.mLayers.size() - 1;
    }

    @Override
    public Rect getTileAreaInImageCoords(TilePositionInPyramid tilePositionInPyramid) {
        TileDimensionsInImage tileSizesInImage = this.calculateTileDimensionsInImageCoords(tilePositionInPyramid);
        int left = tileSizesInImage.basicSize * tilePositionInPyramid.getPositionInLayer().column;
        int right = left + tileSizesInImage.actualWidth;
        int top = tileSizesInImage.basicSize * tilePositionInPyramid.getPositionInLayer().row;
        int bottom = top + tileSizesInImage.actualHeight;
        return new Rect(left, top, right, bottom);
    }

    @Override
    public String buildTileUrl(TilePositionInPyramid tilePositionInPyramid) {
        int tileGroup = this.computeTileGroup(tilePositionInPyramid);
        String tileUrl = this.buildTileUrl(tileGroup, tilePositionInPyramid);
        LOGGER.v("TILE URL: " + tileUrl);
        return tileUrl;
    }

    @Override
    public TiledImageProtocol getTiledImageProtocol() {
        return TiledImageProtocol.ZOOMIFY;
    }

    private TileDimensionsInImage calculateTileDimensionsInImageCoords(TilePositionInPyramid tilePositionInPyramid) {
        this.checkInitialized();
        int basicSize = this.getTilesBasicSizeInImageCoordsForGivenLayer(tilePositionInPyramid.getLayer());
        int width = this.getTileWidthInImageCoords(tilePositionInPyramid.getLayer(), tilePositionInPyramid.getPositionInLayer().column, basicSize);
        int height = this.getTileHeightInImageCoords(tilePositionInPyramid.getLayer(), tilePositionInPyramid.getPositionInLayer().row, basicSize);
        return new TileDimensionsInImage(basicSize, width, height);
    }

    private int getTilesBasicSizeInImageCoordsForGivenLayer(int layerId) {
        return this.mImageMetadata.getTileSize() * (int)Math.pow(2.0, this.mLayers.size() - layerId - 1);
    }

    private int getTileWidthInImageCoords(int layerId, int tileHorizontalIndex, int basicSize) {
        if (tileHorizontalIndex == this.mLayers.get(layerId).getTilesHorizontal() - 1) {
            int result = this.mImageMetadata.getWidth() - basicSize * (this.mLayers.get(layerId).getTilesHorizontal() - 1);
            return result;
        }
        return basicSize;
    }

    private int getTileHeightInImageCoords(int layerId, int tileVerticalIndex, int basicSize) {
        int verticalTilesForLayer = this.mLayers.get(layerId).getTilesVertical();
        int lastTilesIndex = verticalTilesForLayer - 1;
        if (tileVerticalIndex == lastTilesIndex) {
            return this.mImageMetadata.getHeight() - basicSize * lastTilesIndex;
        }
        return basicSize;
    }

    private double getLayerWidth(int layerId) {
        this.checkInitialized();
        double result = this.mImageMetadata.getWidth() / Utils.pow(2, this.mLayers.size() - layerId - 1);
        return result;
    }

    private double getLayerHeight(int layerId) {
        this.checkInitialized();
        return this.mImageMetadata.getHeight() / Utils.pow(2, this.mLayers.size() - layerId - 1);
    }

    @Override
    public void cancelAllTasks() {
        this.taskRegistry.cancelAllTasks();
    }

    @Override
    public void enqueTileDownload(TilePositionInPyramid tilePositionInPyramid, TiledImageView.TileDownloadErrorListener errorListener, TiledImageView.TileDownloadSuccessListener successListener) {
        String tileImageUrl = this.buildTileUrl(tilePositionInPyramid);
        this.taskRegistry.enqueueTileDownloadTask(tilePositionInPyramid, tileImageUrl, errorListener, successListener);
    }

    @Override
    public void cancelFetchingATilesForLayerExeptForThese(int layerId, List<TilePositionInPyramid> visibleTiles) {
        this.checkInitialized();
        for (TilePositionInPyramid runningTilePositionInPyramid : this.taskRegistry.getAllTileDownloadTaskIds()) {
            if (runningTilePositionInPyramid.getLayer() != layerId || visibleTiles.contains(runningTilePositionInPyramid)) continue;
            boolean bl = this.taskRegistry.cancel(runningTilePositionInPyramid);
        }
    }
}

