/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.tasks;

import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.TiledImageView;
import cz.mzk.tiledimageview.images.ImageManager;
import cz.mzk.tiledimageview.images.TilePositionInPyramid;
import cz.mzk.tiledimageview.images.tasks.DownloadAndSaveTileTask;
import cz.mzk.tiledimageview.images.tasks.InitImageManagerTask;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;

public class ImageManagerTaskRegistry {
    public static final int MAX_TASKS_IN_POOL = 30;
    private static final Logger LOGGER = new Logger(ImageManagerTaskRegistry.class);
    private final ImageManager mImgManager;
    private final Map<TilePositionInPyramid, DownloadAndSaveTileTask> mTileDownloadTasks = new HashMap<TilePositionInPyramid, DownloadAndSaveTileTask>();
    private InitImageManagerTask mInitMetadataTask;

    public ImageManagerTaskRegistry(ImageManager imgManager) {
        this.mImgManager = imgManager;
    }

    public void enqueueTileDownloadTask(final TilePositionInPyramid tilePosition, String tileImageUrl, TiledImageView.TileDownloadErrorListener errorListener, TiledImageView.TileDownloadSuccessListener successListener) {
        if (this.mTileDownloadTasks.size() < 30) {
            if (!this.mTileDownloadTasks.containsKey(tilePosition)) {
                LOGGER.d(String.format("enqueuing tile-download task: %s, (total %d)", tileImageUrl, this.mTileDownloadTasks.size()));
                DownloadAndSaveTileTask task = new DownloadAndSaveTileTask(tileImageUrl, errorListener, successListener, new TaskFinishedListener(){

                    @Override
                    public void onTaskFinished() {
                        ImageManagerTaskRegistry.this.mTileDownloadTasks.remove(tilePosition);
                    }
                });
                this.mTileDownloadTasks.put(tilePosition, task);
                try {
                    task.executeConcurrentIfPossible(new Void[0]);
                }
                catch (RejectedExecutionException e) {
                    LOGGER.w("to many threads in execution pool");
                    this.mTileDownloadTasks.remove(tilePosition);
                }
            } else {
                LOGGER.d(String.format("ignoring tile-download task for '%s' (already in queue)", tileImageUrl));
            }
        } else {
            LOGGER.d(String.format("ignoring tile-download task for '%s' (queue full - %d items)", tileImageUrl, this.mTileDownloadTasks.size()));
        }
    }

    public void enqueueMetadataInitializationTask(String metadataUrl, TiledImageView.MetadataInitializationHandler handler, TiledImageView.MetadataInitializationSuccessListener successListener) {
        if (this.mInitMetadataTask == null) {
            LOGGER.d("enqueuing metadata-initialization task");
            this.mInitMetadataTask = new InitImageManagerTask(this.mImgManager, metadataUrl, handler, successListener, new TaskFinishedListener(){

                @Override
                public void onTaskFinished() {
                    ImageManagerTaskRegistry.this.mInitMetadataTask = null;
                }
            });
            try {
                this.mInitMetadataTask.executeConcurrentIfPossible(new Void[0]);
            }
            catch (RejectedExecutionException e) {
                LOGGER.w("to many threads in execution pool");
                this.mInitMetadataTask = null;
            }
        } else {
            LOGGER.d("ignoring metadata-initialization task - already in queue");
        }
    }

    public void cancelAllTasks() {
        LOGGER.d("canceling all tasks");
        if (this.mInitMetadataTask != null) {
            this.mInitMetadataTask.cancel(false);
            this.mInitMetadataTask = null;
        }
        for (DownloadAndSaveTileTask task : this.mTileDownloadTasks.values()) {
            task.cancel(false);
        }
    }

    public boolean cancel(TilePositionInPyramid id) {
        DownloadAndSaveTileTask task = this.mTileDownloadTasks.get(id);
        if (task != null) {
            LOGGER.d(String.format("canceling tile-download task for %s", id.toString()));
            task.cancel(false);
            return true;
        }
        return false;
    }

    public Set<TilePositionInPyramid> getAllTileDownloadTaskIds() {
        return this.mTileDownloadTasks.keySet();
    }

    public static interface TaskFinishedListener {
        public void onTaskFinished();
    }
}

