/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.tasks;

import android.graphics.Bitmap;
import cz.mzk.tiledimageview.ConcurrentAsyncTask;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.TiledImageView;
import cz.mzk.tiledimageview.cache.CacheManager;
import cz.mzk.tiledimageview.images.Downloader;
import cz.mzk.tiledimageview.images.exceptions.ImageServerResponseException;
import cz.mzk.tiledimageview.images.exceptions.InvalidDataException;
import cz.mzk.tiledimageview.images.exceptions.OtherIOException;
import cz.mzk.tiledimageview.images.exceptions.TooManyRedirectionsException;
import cz.mzk.tiledimageview.images.tasks.ImageManagerTaskRegistry;

public class DownloadAndSaveTileTask
extends ConcurrentAsyncTask<Void, Void, Boolean> {
    private static final Logger LOGGER = new Logger(DownloadAndSaveTileTask.class);
    private final String mTileImageUrl;
    private final TiledImageView.TileDownloadErrorListener mErrorListener;
    private final TiledImageView.TileDownloadSuccessListener mSuccessListener;
    private final ImageManagerTaskRegistry.TaskFinishedListener mRegistryListener;
    private OtherIOException otherIoException;
    private TooManyRedirectionsException tooManyRedirectionsException;
    private ImageServerResponseException imageServerResponseException;
    private InvalidDataException invalidXmlException;

    public DownloadAndSaveTileTask(String tileImageUrl, TiledImageView.TileDownloadErrorListener errorListener, TiledImageView.TileDownloadSuccessListener successListener, ImageManagerTaskRegistry.TaskFinishedListener taskFinishedListener) {
        this.mTileImageUrl = tileImageUrl;
        this.mErrorListener = errorListener;
        this.mSuccessListener = successListener;
        this.mRegistryListener = taskFinishedListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doInBackground(Void ... params) {
        try {
            if (!this.isCancelled()) {
                Bitmap tile = Downloader.downloadTile(this.mTileImageUrl);
                if (!this.isCancelled()) {
                    if (tile != null) {
                        CacheManager.getTilesCache().storeTile(tile, this.mTileImageUrl);
                        LOGGER.v(String.format("tile downloaded and saved to disk cache: '%s'", this.mTileImageUrl));
                        Boolean bl = true;
                        return bl;
                    }
                    LOGGER.w("tile is null");
                } else {
                    LOGGER.v(String.format("tile processing canceled task after downloading and before saving data: '%s'", this.mTileImageUrl));
                }
            } else {
                LOGGER.v(String.format("tile processing task canceled before download started: '%s'", this.mTileImageUrl));
            }
        }
        catch (TooManyRedirectionsException e) {
            this.tooManyRedirectionsException = e;
        }
        catch (ImageServerResponseException e) {
            this.imageServerResponseException = e;
        }
        catch (OtherIOException e) {
            this.otherIoException = e;
        }
        finally {
            LOGGER.v("tile processing task finished");
        }
        return false;
    }

    protected void onPostExecute(Boolean success) {
        if (this.mRegistryListener != null) {
            this.mRegistryListener.onTaskFinished();
        }
        if (this.mSuccessListener != null && success.booleanValue()) {
            this.mSuccessListener.onTileDownloaded();
        } else if (this.mErrorListener != null) {
            if (this.tooManyRedirectionsException != null) {
                this.mErrorListener.onTileRedirectionLoop(this.tooManyRedirectionsException.getUrl(), this.tooManyRedirectionsException.getRedirections());
            } else if (this.imageServerResponseException != null) {
                this.mErrorListener.onTileUnhandableResponse(this.imageServerResponseException.getUrl(), this.imageServerResponseException.getErrorCode());
            } else if (this.invalidXmlException != null) {
                this.mErrorListener.onTileInvalidDataError(this.invalidXmlException.getUrl(), this.invalidXmlException.getMessage());
            } else if (this.otherIoException != null) {
                this.mErrorListener.onTileDataTransferError(this.otherIoException.getUrl(), this.otherIoException.getMessage());
            }
        }
    }

    protected void onCancelled() {
        super.onCancelled();
        if (this.mRegistryListener != null) {
            this.mRegistryListener.onTaskFinished();
        }
    }
}

