/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.gestures;

import android.graphics.Rect;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.PointD;
import cz.mzk.tiledimageview.TiledImageViewApi;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.VectorD;
import cz.mzk.tiledimageview.dev.DevTools;
import cz.mzk.tiledimageview.gestures.RectD;

public class GestureHandler {
    private static final Logger LOGGER = new Logger(GestureHandler.class);
    protected final TiledImageViewApi mImageViewApi;
    protected final DevTools mDevTools;

    public GestureHandler(TiledImageViewApi imageView, DevTools devTools) {
        this.mImageViewApi = imageView;
        this.mDevTools = devTools;
    }

    protected VectorD limitNewShift(VectorD newShift) {
        double extraSpaceVerticalCanv;
        double limitedGlobalY;
        double extraSpaceHorizontalCanv;
        double limitedLocalX = newShift.x;
        double limitedLocalY = newShift.y;
        double scaleFactor = this.mImageViewApi.getTotalScaleFactor();
        RectD paddingRectImg = new RectD(0.0, 0.0, this.mImageViewApi.getCanvasImagePaddingHorizontal(), this.mImageViewApi.getCanvasImagePaddingVertical());
        Rect imageAreaInCanvasWithoutAnyShift = this.computeWholeImageAreaInCanvasCoords(scaleFactor, VectorD.ZERO_VECTOR);
        RectD paddingRectCanv = this.convertToPaddingInCanvas(paddingRectImg, imageAreaInCanvasWithoutAnyShift);
        VectorD totalShift = this.mImageViewApi.getTotalShift();
        VectorD totalPlusNewShift = totalShift.plus(newShift);
        Rect imageAreaInCanvasWithNewShift = this.computeWholeImageAreaInCanvasCoords(scaleFactor, totalPlusNewShift);
        double maxTop = extraSpaceHorizontalCanv = paddingRectCanv.height();
        double minBottom = (double)this.mImageViewApi.getHeight() - extraSpaceHorizontalCanv;
        if ((double)imageAreaInCanvasWithNewShift.top > maxTop) {
            limitedGlobalY = maxTop;
            limitedLocalY = limitedGlobalY - totalShift.y;
        } else if ((double)imageAreaInCanvasWithNewShift.bottom < minBottom) {
            limitedGlobalY = minBottom - (double)imageAreaInCanvasWithoutAnyShift.bottom;
            limitedLocalY = limitedGlobalY - totalShift.y;
        }
        double maxLeft = extraSpaceVerticalCanv = paddingRectCanv.width();
        double minRight = (double)this.mImageViewApi.getWidth() - extraSpaceVerticalCanv;
        if ((double)imageAreaInCanvasWithNewShift.left > maxLeft) {
            double limitedGlobalX = maxLeft;
            limitedLocalX = limitedGlobalX - totalShift.x;
        } else if ((double)imageAreaInCanvasWithNewShift.right < minRight) {
            double limitedGlobalX = minRight - (double)imageAreaInCanvasWithoutAnyShift.right;
            limitedLocalX = limitedGlobalX - totalShift.x;
        }
        return new VectorD(limitedLocalX, limitedLocalY);
    }

    private RectD convertToPaddingInCanvas(RectD paddingRectImg, Rect imageAreaInCanvasWithoutAnyShift) {
        double min;
        PointD rightBottomImg = new PointD(paddingRectImg.right, paddingRectImg.bottom);
        PointD rightBottomCanv = Utils.toCanvasCoords(rightBottomImg, this.mImageViewApi.getMinScaleFactor(), VectorD.ZERO_VECTOR);
        double width = rightBottomCanv.x;
        double height = rightBottomCanv.y;
        if (width != 0.0) {
            if (imageAreaInCanvasWithoutAnyShift.width() >= this.mImageViewApi.getWidth()) {
                width = 0.0;
            } else {
                min = (double)(this.mImageViewApi.getWidth() - imageAreaInCanvasWithoutAnyShift.width()) * 0.5;
                width = Math.min(width, min);
            }
        }
        if (height != 0.0) {
            if (imageAreaInCanvasWithoutAnyShift.height() >= this.mImageViewApi.getHeight()) {
                height = 0.0;
            } else {
                min = (double)(this.mImageViewApi.getHeight() - imageAreaInCanvasWithoutAnyShift.height()) * 0.5;
                height = Math.min(height, min);
            }
        }
        return new RectD(0.0, 0.0, width, height);
    }

    private void devVisualisePaddingArea(RectD paddingRectCanv) {
        if (this.mDevTools != null) {
            Rect paddingRectangleVisualisation = this.paddingVisualisation(paddingRectCanv);
            this.mDevTools.addToRectStack(new DevTools.RectWithPaint(paddingRectangleVisualisation, this.mDevTools.getPaintGreen()));
        }
    }

    private Rect paddingVisualisation(RectD paddingRectCanv) {
        int x = (int)paddingRectCanv.width();
        int y = (int)paddingRectCanv.height();
        if (x == 0) {
            x = 10;
        }
        if (y == 0) {
            y = 10;
        }
        return new Rect(0, 0, x, y);
    }

    Rect computeWholeImageAreaInCanvasCoords(double scaleFactor, VectorD shift) {
        Rect imgArea = new Rect(0, 0, this.mImageViewApi.getImageWidth(), this.mImageViewApi.getImageHeight());
        return Utils.toCanvasCoords(imgArea, scaleFactor, shift);
    }
}

