/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.cache.tmp;

import android.content.Context;
import android.graphics.Bitmap;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.cache.tmp.AbstractTileCache;
import cz.mzk.tiledimageview.cache.tmp.DiskTilesCache;
import cz.mzk.tiledimageview.cache.tmp.MemoryAndDiskTilesCache;
import cz.mzk.tiledimageview.cache.tmp.MemoryTilesCache;
import cz.mzk.tiledimageview.cache.tmp.TilesCache;
import cz.mzk.tiledimageview.images.TilePositionInPyramid;

public class MemoryAndDiskTilesMulticache
extends AbstractTileCache
implements TilesCache {
    private static final Logger LOGGER = new Logger(MemoryAndDiskTilesMulticache.class);
    private static final int MIN_MEMORY_CACHE_SIZE_KB = 2048;
    private static final int MIN_DISK_CACHE_SIZE_KB = 1024;
    private static final String DISK_CACH_DIR_NAME_LEVEL_0 = "tiles0";
    private static final String DISK_CACH_DIR_NAME_LEVEL_1 = "tiles1";
    private static final String DISK_CACH_DIR_NAME_LEVEL_2 = "tiles2";
    private static final String DISK_CACH_DIR_NAME_LEVEL_OTHER = "tilesOther";
    private TilesCache level0;
    private TilesCache level1;
    private TilesCache level2;
    private TilesCache levelOther;
    private TilesCache.State state = TilesCache.State.INITIALIZING;

    public MemoryAndDiskTilesMulticache(Context context, boolean clearCache) {
        this(context, MemoryAndDiskTilesMulticache.getDefaultMemoryCacheSizeKB(), 0xA00000, clearCache);
    }

    public MemoryAndDiskTilesMulticache(Context context, int memoryCacheSize, int diskCacheSize, boolean clearCache) {
        int[] diskSpace = this.distributeDiskSpace(diskCacheSize);
        int[] memorySpace = this.distributeMemorySpace(memoryCacheSize);
        this.level0 = this.initCache(context, DISK_CACH_DIR_NAME_LEVEL_0, memorySpace[0], diskSpace[0], clearCache);
        this.level1 = this.initCache(context, DISK_CACH_DIR_NAME_LEVEL_1, memorySpace[1], diskSpace[1], clearCache);
        this.level2 = this.initCache(context, DISK_CACH_DIR_NAME_LEVEL_2, memorySpace[2], diskSpace[2], clearCache);
        this.levelOther = this.initCache(context, DISK_CACH_DIR_NAME_LEVEL_OTHER, memorySpace[3], diskSpace[3], clearCache);
        this.state = TilesCache.State.READY;
    }

    private TilesCache initCache(Context context, String diskCachDir, int memoryCacheSize, int diskCacheSize, boolean clearCache) {
        LOGGER.d("initializing cache: memory: " + memoryCacheSize + " KB, disk: " + diskCacheSize + " KB (" + diskCachDir + ")");
        if (diskCacheSize != 0 && memoryCacheSize != 0) {
            return new MemoryAndDiskTilesCache(context, memoryCacheSize, diskCacheSize, diskCachDir, clearCache);
        }
        if (diskCacheSize == 0 && memoryCacheSize != 0) {
            return new MemoryTilesCache(memoryCacheSize);
        }
        if (diskCacheSize != 0 && memoryCacheSize == 0) {
            return new DiskTilesCache(context, diskCacheSize, diskCachDir, clearCache);
        }
        return null;
    }

    private int[] distributeMemorySpace(int totalSize) {
        int minSize = 2048;
        int level0 = 0;
        int level1 = 0;
        int level2 = 0;
        int levelOther = 0;
        if (totalSize < minSize) {
            return new int[]{0, 0, 0, 0};
        }
        int[] halfs = this.splitIfBigEnough(totalSize, minSize);
        levelOther = halfs[1];
        int secondHalf = halfs[1];
        if (secondHalf != 0) {
            int[] quarters = this.splitIfBigEnough(secondHalf, minSize);
            level2 = quarters[0];
            int secondQuarter = quarters[1];
            if (secondQuarter != 0) {
                int[] eights = this.splitIfBigEnough(secondQuarter, minSize);
                level1 = eights[0];
                int secondEight = eights[1];
                if (secondEight != 0) {
                    level0 = secondEight;
                }
            }
        }
        return new int[]{level0, level1, level2, levelOther};
    }

    private int[] splitIfBigEnough(int total, int minSize) {
        int half = total / 2;
        if (half < minSize) {
            return new int[]{total, 0};
        }
        return new int[]{half, total - half};
    }

    private int[] distributeDiskSpace(int totalSize) {
        int minSize = 1024;
        int level0 = 0;
        int level1 = 0;
        int level2 = 0;
        int levelOther = 0;
        if (totalSize < minSize) {
            return new int[]{0, 0, 0, 0};
        }
        int[] halfs = this.splitIfBigEnough(totalSize, minSize);
        level0 = halfs[1];
        int secondHalf = halfs[1];
        if (secondHalf != 0) {
            int[] quarters = this.splitIfBigEnough(secondHalf, minSize);
            level1 = quarters[0];
            int secondQuarter = quarters[1];
            if (secondQuarter != 0) {
                int[] eights = this.splitIfBigEnough(secondQuarter, minSize);
                level2 = eights[0];
                int secondEight = eights[1];
                if (secondEight != 0) {
                    levelOther = secondEight;
                }
            }
        }
        return new int[]{level0, level1, level2, levelOther};
    }

    @Override
    public Bitmap getTile(String zoomifyBaseUrl, TilePositionInPyramid tilePositionInPyramid) {
        switch (tilePositionInPyramid.getLayer()) {
            case 0: {
                return this.level0 != null && this.level0.getState() == TilesCache.State.READY ? this.level0.getTile(zoomifyBaseUrl, tilePositionInPyramid) : null;
            }
            case 1: {
                return this.level1 != null && this.level1.getState() == TilesCache.State.READY ? this.level1.getTile(zoomifyBaseUrl, tilePositionInPyramid) : null;
            }
            case 2: {
                return this.level2 != null && this.level2.getState() == TilesCache.State.READY ? this.level2.getTile(zoomifyBaseUrl, tilePositionInPyramid) : null;
            }
        }
        return this.levelOther != null && this.levelOther.getState() == TilesCache.State.READY ? this.levelOther.getTile(zoomifyBaseUrl, tilePositionInPyramid) : null;
    }

    @Override
    public void storeTile(Bitmap tile, String zoomifyBaseUrl, TilePositionInPyramid tilePositionInPyramid) {
        switch (tilePositionInPyramid.getLayer()) {
            case 0: {
                if (this.level0 == null || this.level0.getState() != TilesCache.State.READY) break;
                this.level0.storeTile(tile, zoomifyBaseUrl, tilePositionInPyramid);
                break;
            }
            case 1: {
                if (this.level1 == null || this.level1.getState() != TilesCache.State.READY) break;
                this.level1.storeTile(tile, zoomifyBaseUrl, tilePositionInPyramid);
                break;
            }
            case 2: {
                if (this.level2 == null || this.level2.getState() != TilesCache.State.READY) break;
                this.level2.storeTile(tile, zoomifyBaseUrl, tilePositionInPyramid);
                break;
            }
            default: {
                if (this.levelOther == null || this.levelOther.getState() != TilesCache.State.READY) break;
                this.levelOther.storeTile(tile, zoomifyBaseUrl, tilePositionInPyramid);
            }
        }
    }

    @Override
    public TilesCache.State getState() {
        return this.state;
    }
}

