/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.cache.tmp;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.util.LruCache;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.cache.DiskLruCache;
import cz.mzk.tiledimageview.cache.InitDiskCacheTask;
import cz.mzk.tiledimageview.cache.tmp.AbstractTileCache;
import cz.mzk.tiledimageview.cache.tmp.TilesCache;
import cz.mzk.tiledimageview.images.TilePositionInPyramid;
import java.io.File;
import java.io.InputStream;

public class MemoryAndDiskTilesCache
extends AbstractTileCache
implements TilesCache {
    private static final Logger LOGGER = new Logger(MemoryAndDiskTilesCache.class);
    private static final int DEFAULT_DISK_CACHE_SIZE = 0xA00000;
    private static final String DEFAULT_DISK_CACHE_SUBDIR = "tiles";
    private final Object mDiskCacheInitializationLock = new Object();
    private final LruCache<String, Bitmap> mMemoryCache;
    private DiskLruCache mDiskCache = null;
    private boolean mDiskCacheDisabled = false;
    private TilesCache.State state = TilesCache.State.INITIALIZING;

    public MemoryAndDiskTilesCache(Context context, int cacheSizeKB, int diskCacheSize, String diskCacheDir, boolean clearCache) {
        int maxItems = 50;
        this.mMemoryCache = new LruCache(maxItems);
        LOGGER.d("Lru cache allocated, max items: " + maxItems);
        this.initDiskCacheAsync(context, diskCacheSize, diskCacheDir, clearCache);
    }

    public MemoryAndDiskTilesCache(Context context, boolean clearCache) {
        this(context, MemoryAndDiskTilesCache.getDefaultMemoryCacheSizeKB(), 0xA00000, DEFAULT_DISK_CACHE_SUBDIR, clearCache);
    }

    private void initDiskCacheAsync(Context context, int diskCacheSize, String diskCacheDir, boolean clearCache) {
        try {
            File cacheDir = MemoryAndDiskTilesCache.getDiskCacheDir(context, diskCacheDir);
            int appVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
            new InitDiskCacheTask(appVersion, diskCacheSize, clearCache, new InitDiskCacheTask.Listener(){

                @Override
                public void onFinished(DiskLruCache cache) {
                    MemoryAndDiskTilesCache.this.mDiskCache = cache;
                    MemoryAndDiskTilesCache.this.state = TilesCache.State.READY;
                }

                @Override
                public void onError() {
                    LOGGER.i("disabling disk cache");
                    MemoryAndDiskTilesCache.this.mDiskCacheDisabled = true;
                    MemoryAndDiskTilesCache.this.state = MemoryAndDiskTilesCache.this.mMemoryCache != null ? TilesCache.State.READY : TilesCache.State.DISABLED;
                }
            }).execute(new File[]{cacheDir});
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void storeTile(Bitmap bmp, String zoomifyBaseUrl, TilePositionInPyramid tilePositionInPyramid) {
        String key = this.buildKey(zoomifyBaseUrl, tilePositionInPyramid);
        this.storeTileToMemoryCache(key, bmp);
        this.storeTileToDiskCache(key, bmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTileToMemoryCache(String key, Bitmap bmp) {
        LruCache<String, Bitmap> lruCache = this.mMemoryCache;
        synchronized (lruCache) {
            if (this.mMemoryCache.get((Object)key) == null) {
                this.mMemoryCache.put((Object)key, (Object)bmp);
            }
        }
    }

    private void storeTileToDiskCache(String key, Bitmap bmp) {
    }

    @Override
    public Bitmap getTile(String zoomifyBaseUrl, TilePositionInPyramid tilePositionInPyramid) {
        String key = this.buildKey(zoomifyBaseUrl, tilePositionInPyramid);
        Bitmap inMemoryCache = (Bitmap)this.mMemoryCache.get((Object)key);
        if (inMemoryCache != null) {
            return inMemoryCache;
        }
        Bitmap fromDiskCache = this.getTileFromDiskCache(key);
        if (fromDiskCache != null) {
            new StoreTileToMemoryCacheTask(key).execute(new Bitmap[]{fromDiskCache});
        }
        return fromDiskCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDiskCacheInitializedOrDisabled() {
        try {
            Object object = this.mDiskCacheInitializationLock;
            synchronized (object) {
                while (this.mDiskCache == null && !this.mDiskCacheDisabled) {
                    try {
                        this.mDiskCacheInitializationLock.wait();
                    }
                    catch (InterruptedException e) {
                        LOGGER.e("waiting for disk cache lock interrupted", e);
                    }
                }
            }
        }
        finally {
            LOGGER.v("releasing disk cache initialization lock: " + Thread.currentThread().toString());
        }
    }

    private Bitmap getTileFromDiskCache(String key) {
        this.waitUntilDiskCacheInitializedOrDisabled();
        try {
            if (this.mDiskCache != null && !this.mDiskCacheDisabled) {
                DiskLruCache.Snapshot snapshot = this.mDiskCache.get(key);
                if (snapshot != null) {
                    InputStream in = snapshot.getInputStream(0);
                    Bitmap stream = BitmapFactory.decodeStream((InputStream)in);
                    return stream;
                }
                return null;
            }
            return null;
        }
        catch (DiskLruCache.DiskLruCacheException e) {
            LOGGER.e("error loading tile from disk cache: " + key, e);
            return null;
        }
    }

    @Override
    public TilesCache.State getState() {
        return this.state;
    }

    private class StoreTileToMemoryCacheTask
    extends AsyncTask<Bitmap, Void, Void> {
        private final String key;

        public StoreTileToMemoryCacheTask(String key) {
            this.key = key;
        }

        protected Void doInBackground(Bitmap ... params) {
            MemoryAndDiskTilesCache.this.storeTileToMemoryCache(this.key, params[0]);
            return null;
        }
    }
}

