/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.cache;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.os.Build;
import android.util.LruCache;
import cz.mzk.tiledimageview.ConcurrentAsyncTask;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.cache.AbstractTileCache;
import cz.mzk.tiledimageview.cache.BitmapFetchTaskRegistry;
import cz.mzk.tiledimageview.cache.DiskLruCache;
import cz.mzk.tiledimageview.cache.DiskUtils;
import cz.mzk.tiledimageview.cache.TileBitmap;
import cz.mzk.tiledimageview.cache.TilesCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;

public class MemoryAndDiskTilesCache
extends AbstractTileCache
implements TilesCache {
    public static final String DISK_CACHE_SUBDIR = "tiles";
    private static final Logger LOGGER = new Logger(MemoryAndDiskTilesCache.class);
    private final Object mMemoryCacheLock = new Object();
    private final BitmapFetchTaskRegistry mBitmapFetchManager;
    private final Object mDiskCacheInitializationLock = new Object();
    private LruCache<String, Bitmap> mMemoryCache;
    private boolean mDiskCacheEnabled;
    private DiskLruCache mDiskCache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryAndDiskTilesCache(Context context, int memoryCacheMaxItems, boolean diskCacheEnabled, boolean clearDiskCache, long diskCacheBytes) {
        this.mDiskCacheEnabled = diskCacheEnabled;
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            this.mMemoryCache = new LruCache(memoryCacheMaxItems);
        }
        LOGGER.i("memory cache initialized; max items: " + memoryCacheMaxItems);
        this.mBitmapFetchManager = new BitmapFetchTaskRegistry(this);
        if (this.mDiskCacheEnabled) {
            this.initDiskCacheAsync(context, clearDiskCache, diskCacheBytes);
        }
    }

    private LruCache<String, Bitmap> initMemoryCacheFixedSize() {
        int maxMemoryKB = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int cacheSizeKB = maxMemoryKB / 8;
        LruCache<String, Bitmap> cache = new LruCache<String, Bitmap>(cacheSizeKB){

            protected int sizeOf(String key, Bitmap bitmap) {
                return MemoryAndDiskTilesCache.this.getBitmapSizeInKB(bitmap);
            }
        };
        return cache;
    }

    private void initDiskCacheAsync(Context context, boolean clearCache, long diskCacheBytes) {
        try {
            File cacheDir = this.getDiskCacheDir(context);
            int appVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
            new InitDiskCacheTask(appVersion, clearCache, diskCacheBytes).execute(new File[]{cacheDir});
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private File getDiskCacheDir(Context context) {
        String cacheDirPath = context.getCacheDir().getPath();
        return new File(cacheDirPath + File.separator + DISK_CACHE_SUBDIR);
    }

    private void disableDiskCache() {
        LOGGER.i("disabling disk cache");
        this.mDiskCacheEnabled = false;
    }

    @Override
    public void storeTile(Bitmap tile, String tileUrl) {
        String key = this.buildKey(tileUrl);
        this.storeTileToMemoryCache(key, tile);
        this.storeTileToDiskCache(key, tile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeTileToMemoryCache(String key, Bitmap bmp) {
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            if (this.mMemoryCache.get((Object)key) == null) {
                this.mMemoryCache.put((Object)key, (Object)bmp);
            }
        }
    }

    private void storeTileToDiskCache(String key, Bitmap bmp) {
        this.waitUntilDiskCacheInitializedOrDisabled();
        try {
            if (this.mDiskCacheEnabled) {
                DiskLruCache.Snapshot fromDiskCache = this.mDiskCache.get(key);
                if (fromDiskCache != null) {
                    LOGGER.d("already in disk cache: " + key);
                } else {
                    LOGGER.d("storing to disk cache: " + key);
                    this.mDiskCache.storeBitmap(0, key, bmp);
                }
            }
        }
        catch (DiskLruCache.DiskLruCacheException e) {
            LOGGER.e("failed to store tile to disk cache: " + key, e);
        }
    }

    @Override
    public Bitmap getTile(String tileUrl) {
        String key = this.buildKey(tileUrl);
        Bitmap inMemoryCache = this.getTileFromMemoryCache(key);
        if (inMemoryCache != null) {
            return inMemoryCache;
        }
        Bitmap fromDiskCache = this.getTileFromDiskCache(key);
        if (fromDiskCache != null) {
            try {
                new StoreTileToMemoryCacheTask(key).executeConcurrentIfPossible(fromDiskCache);
            }
            catch (RejectedExecutionException e) {
                LOGGER.w("to many threads in execution pool");
            }
        }
        return fromDiskCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap getTileFromMemoryCache(String key) {
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            return (Bitmap)this.mMemoryCache.get((Object)key);
        }
    }

    @Override
    public boolean containsTile(String tileUrl) {
        String key = this.buildKey(tileUrl);
        Bitmap inMemory = this.getTileFromMemoryCache(key);
        if (inMemory != null) {
            return true;
        }
        return this.diskCacheContainsTile(key);
    }

    @Override
    public boolean containsTileInMemory(String tileUrl) {
        String key = this.buildKey(tileUrl);
        Bitmap inMemory = this.getTileFromMemoryCache(key);
        return inMemory != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDiskCacheInitializedOrDisabled() {
        try {
            Object object = this.mDiskCacheInitializationLock;
            synchronized (object) {
                while (this.mDiskCache == null && this.mDiskCacheEnabled) {
                    try {
                        this.mDiskCacheInitializationLock.wait();
                    }
                    catch (InterruptedException e) {
                        LOGGER.e("waiting for disk cache lock interrupted", e);
                    }
                }
            }
        }
        finally {
            LOGGER.v("releasing disk cache initialization lock: " + Thread.currentThread().toString());
        }
    }

    private boolean diskCacheContainsTile(String key) {
        this.waitUntilDiskCacheInitializedOrDisabled();
        try {
            if (this.mDiskCacheEnabled) {
                return this.mDiskCache.containsReadable(key);
            }
            return false;
        }
        catch (IOException e) {
            LOGGER.e("error loading tile from disk cache: " + key, e);
            return false;
        }
    }

    protected Bitmap getTileFromDiskCache(String key) {
        this.waitUntilDiskCacheInitializedOrDisabled();
        try {
            if (this.mDiskCacheEnabled) {
                DiskLruCache.Snapshot snapshot = this.mDiskCache.get(key);
                if (snapshot != null) {
                    InputStream in = snapshot.getInputStream(0);
                    Bitmap stream = BitmapFactory.decodeStream((InputStream)in);
                    if (stream == null) {
                        LOGGER.w("bitmap from disk cache was null, removing record");
                        this.mDiskCache.remove(key);
                    }
                    return stream;
                }
                return null;
            }
            return null;
        }
        catch (DiskLruCache.DiskLruCacheException e) {
            LOGGER.e("error loading tile from disk cache: " + key, e);
            return null;
        }
    }

    @Override
    public TileBitmap getTileAsync(String tileUrl, TilesCache.FetchingBitmapFromDiskHandler handler) {
        String key = this.buildKey(tileUrl);
        Bitmap inMemoryCache = this.getTileFromMemoryCache(key);
        if (inMemoryCache != null) {
            return new TileBitmap(TileBitmap.State.IN_MEMORY, inMemoryCache);
        }
        if (this.mDiskCacheEnabled) {
            try {
                if (this.mDiskCache.containsReadable(key)) {
                    this.mBitmapFetchManager.registerTask(key, handler);
                    return new TileBitmap(TileBitmap.State.IN_DISK, null);
                }
                return new TileBitmap(TileBitmap.State.NOT_FOUND, null);
            }
            catch (IOException e) {
                e.printStackTrace();
                return new TileBitmap(TileBitmap.State.NOT_FOUND, null);
            }
        }
        return new TileBitmap(TileBitmap.State.NOT_FOUND, null);
    }

    @Override
    public void cancelAllTasks() {
        this.mBitmapFetchManager.cancelAllTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMemoryCacheSizeInItems(int minSize) {
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            int currentSize = this.mMemoryCache.maxSize();
            if (currentSize < minSize) {
                LOGGER.d("Increasing cache size " + currentSize + " -> " + minSize + " items");
                if (Build.VERSION.SDK_INT >= 21) {
                    this.mMemoryCache.resize(minSize);
                } else {
                    Map snapshot = this.mMemoryCache.snapshot();
                    this.mMemoryCache = new LruCache(minSize);
                    for (String key : snapshot.keySet()) {
                        this.mMemoryCache.put((Object)key, snapshot.get(key));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.mDiskCache.flush();
        }
        catch (DiskLruCache.DiskLruCacheException e) {
            LOGGER.e("Error flushing disk cache");
        }
        finally {
            try {
                this.mDiskCache.close();
            }
            catch (IOException e) {
                LOGGER.e("Error closing disk cache");
            }
        }
    }

    private class StoreTileToMemoryCacheTask
    extends ConcurrentAsyncTask<Bitmap, Void, Void> {
        private final String key;

        public StoreTileToMemoryCacheTask(String key) {
            this.key = key;
        }

        protected Void doInBackground(Bitmap ... params) {
            MemoryAndDiskTilesCache.this.storeTileToMemoryCache(this.key, params[0]);
            return null;
        }
    }

    private class InitDiskCacheTask
    extends AsyncTask<File, Void, Void> {
        private final int appVersion;
        private final boolean clearCache;
        private final long cacheSizeBytes;

        public InitDiskCacheTask(int appVersion, boolean clearCache, long diskCacheBytes) {
            this.appVersion = appVersion;
            this.clearCache = clearCache;
            this.cacheSizeBytes = diskCacheBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Void doInBackground(File ... params) {
            Object object = MemoryAndDiskTilesCache.this.mDiskCacheInitializationLock;
            synchronized (object) {
                try {
                    File cacheDir = params[0];
                    if (cacheDir.exists()) {
                        if (this.clearCache) {
                            LOGGER.i("clearing disk cache");
                            boolean cleared = DiskUtils.deleteDirContent(cacheDir);
                            if (!cleared) {
                                LOGGER.w("failed to delete content of " + cacheDir.getAbsolutePath());
                                MemoryAndDiskTilesCache.this.disableDiskCache();
                                Void void_ = null;
                                return void_;
                            }
                        }
                    } else {
                        LOGGER.i("creating cache dir " + cacheDir);
                        boolean created = cacheDir.mkdir();
                        if (!created) {
                            LOGGER.w("failed to create cache dir " + cacheDir.getAbsolutePath());
                            MemoryAndDiskTilesCache.this.disableDiskCache();
                            Void void_ = null;
                            return void_;
                        }
                    }
                    LOGGER.d("disk cache dir: " + cacheDir.getAbsolutePath());
                    MemoryAndDiskTilesCache.this.mDiskCache = DiskLruCache.open(cacheDir, this.appVersion, 1, this.cacheSizeBytes);
                    LOGGER.d("disk cache initialized; size: " + Utils.formatBytes(this.cacheSizeBytes));
                    Void void_ = null;
                    return void_;
                }
                catch (DiskLruCache.DiskLruCacheException e) {
                    LOGGER.w("error opening disk cache, disabling");
                    MemoryAndDiskTilesCache.this.disableDiskCache();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    MemoryAndDiskTilesCache.this.mDiskCacheInitializationLock.notifyAll();
                }
            }
        }
    }
}

