/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.cache;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.util.LruCache;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.cache.CacheKeyBuilder;
import cz.mzk.tiledimageview.cache.DiskLruCache;
import cz.mzk.tiledimageview.cache.DiskUtils;
import cz.mzk.tiledimageview.cache.MetadataCache;
import java.io.File;

public class MemoryAndDiskMetadataCache
implements MetadataCache {
    public static final String DISK_CACHE_SUBDIR = "imageProperties";
    public static final int DISK_CACHE_SIZE_B = 0xA00000;
    public static final int MEMORY_CACHE_SIZE_ITEMS = 10;
    private static final Logger LOGGER = new Logger(MemoryAndDiskMetadataCache.class);
    private final Object mMemoryCacheLock = new Object();
    private final LruCache<String, String> mMemoryCache;
    private final Object mDiskCacheInitializationLock = new Object();
    private DiskLruCache mDiskCache = null;
    private boolean mDiskCacheEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryAndDiskMetadataCache(Context context, boolean diskCacheEnabled, boolean clearCache) {
        this.mDiskCacheEnabled = diskCacheEnabled;
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            this.mMemoryCache = this.initMemoryCache();
        }
        if (this.mDiskCacheEnabled) {
            this.initDiskCacheAsync(context, clearCache);
        }
    }

    private LruCache<String, String> initMemoryCache() {
        LruCache cache = new LruCache(10);
        LOGGER.d("in-memory lru cache allocated for 10 items");
        return cache;
    }

    private void initDiskCacheAsync(Context context, boolean clearCache) {
        try {
            File cacheDir = this.getDiskCacheDir(context);
            int appVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
            new InitDiskCacheTask(appVersion, clearCache).execute(new File[]{cacheDir});
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private File getDiskCacheDir(Context context) {
        String cacheDirPath = context.getCacheDir().getPath();
        return new File(cacheDirPath + File.separator + DISK_CACHE_SUBDIR);
    }

    private void disableDiskCache() {
        LOGGER.i("disabling disk cache");
        this.mDiskCacheEnabled = false;
    }

    @Override
    public void storeMetadata(String metadata, String metadataUrl) {
        String key = this.buildKey(metadataUrl);
        this.storeMetadataToMemoryCache(key, metadata);
        this.storeMetadataToDiskCache(key, metadata);
    }

    private String buildKey(String metadataUrl) {
        String key = CacheKeyBuilder.buildKeyFromUrl(metadataUrl);
        if (key.length() > 127) {
            LOGGER.w("cache key is longer then 127 characters");
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMetadataToMemoryCache(String key, String metadata) {
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            LOGGER.v("assuming mMemoryCache lock: " + Thread.currentThread().toString());
            if (this.mMemoryCache.get((Object)key) == null) {
                LOGGER.d("storing to memory cache: " + key);
                this.mMemoryCache.put((Object)key, (Object)metadata);
            } else {
                LOGGER.d("already in memory cache: " + key);
            }
            LOGGER.v("releasing mMemoryCache lock: " + Thread.currentThread().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDiskCacheInitializedOrDisabled() {
        try {
            Object object = this.mDiskCacheInitializationLock;
            synchronized (object) {
                LOGGER.v("assuming disk cache initialization lock: " + Thread.currentThread().toString());
                while (this.mDiskCache == null && this.mDiskCacheEnabled) {
                    try {
                        this.mDiskCacheInitializationLock.wait();
                    }
                    catch (InterruptedException e) {
                        LOGGER.e("waiting for disk cache initialization lock was interrupted", e);
                    }
                }
            }
        }
        finally {
            LOGGER.v("releasing disk cache initialization lock: " + Thread.currentThread().toString());
        }
    }

    private void storeMetadataToDiskCache(String key, String metadata) {
        this.waitUntilDiskCacheInitializedOrDisabled();
        try {
            if (this.mDiskCacheEnabled) {
                DiskLruCache.Snapshot fromDiskCache = this.mDiskCache.get(key);
                if (fromDiskCache != null) {
                    LOGGER.d("already in disk cache: " + key);
                } else {
                    LOGGER.d("storing into disk cache: " + key);
                    this.mDiskCache.storeString(0, key, metadata);
                }
            }
        }
        catch (DiskLruCache.DiskLruCacheException e) {
            LOGGER.e("failed to store into disk cache: " + key, e);
        }
    }

    @Override
    public String getMetadata(String metadataUrl) {
        String key = this.buildKey(metadataUrl);
        String inMemoryCache = this.getMetadataFromMemoryCache(key);
        if (inMemoryCache != null) {
            LOGGER.d("memory cache hit: " + key);
            return inMemoryCache;
        }
        LOGGER.d("memory cache miss: " + key);
        String fromDiskCache = this.getMetadataFromDiskCache(key);
        if (fromDiskCache != null) {
            new StoreMetadataToMemoryCacheTask(key).execute(new String[]{fromDiskCache});
        }
        return fromDiskCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMetadataFromMemoryCache(String key) {
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            return (String)this.mMemoryCache.get((Object)key);
        }
    }

    private String getMetadataFromDiskCache(String key) {
        this.waitUntilDiskCacheInitializedOrDisabled();
        try {
            if (this.mDiskCacheEnabled) {
                DiskLruCache.Snapshot snapshot = this.mDiskCache.get(key);
                if (snapshot != null) {
                    String result = snapshot.getString(0);
                    return result;
                }
                return null;
            }
            return null;
        }
        catch (DiskLruCache.DiskLruCacheException e) {
            LOGGER.w("error loading from disk cache: " + key, e);
            return null;
        }
    }

    private class StoreMetadataToMemoryCacheTask
    extends AsyncTask<String, Void, Void> {
        private final String key;

        public StoreMetadataToMemoryCacheTask(String key) {
            this.key = key;
        }

        protected Void doInBackground(String ... params) {
            MemoryAndDiskMetadataCache.this.storeMetadataToMemoryCache(this.key, params[0]);
            return null;
        }
    }

    private class InitDiskCacheTask
    extends AsyncTask<File, Void, Void> {
        private final int appVersion;
        private final boolean clearCache;

        public InitDiskCacheTask(int appVersion, boolean clearCache) {
            this.appVersion = appVersion;
            this.clearCache = clearCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Void doInBackground(File ... params) {
            Object object = MemoryAndDiskMetadataCache.this.mDiskCacheInitializationLock;
            synchronized (object) {
                LOGGER.v("assuming disk cache initialization lock: " + Thread.currentThread().toString());
                try {
                    File cacheDir = params[0];
                    if (cacheDir.exists()) {
                        if (this.clearCache) {
                            LOGGER.i("clearing metadata disk cache");
                            boolean cleared = DiskUtils.deleteDirContent(cacheDir);
                            if (!cleared) {
                                LOGGER.w("failed to delete content of " + cacheDir.getAbsolutePath());
                                MemoryAndDiskMetadataCache.this.disableDiskCache();
                                Void void_ = null;
                                return void_;
                            }
                        }
                    } else {
                        LOGGER.i("creating cache dir " + cacheDir);
                        boolean created = cacheDir.mkdir();
                        if (!created) {
                            LOGGER.w("failed to create cache dir " + cacheDir.getAbsolutePath());
                            MemoryAndDiskMetadataCache.this.disableDiskCache();
                            Void void_ = null;
                            return void_;
                        }
                    }
                    LOGGER.d("disk cache dir: " + cacheDir.getAbsolutePath());
                    MemoryAndDiskMetadataCache.this.mDiskCache = DiskLruCache.open(cacheDir, this.appVersion, 1, 0xA00000L);
                    LOGGER.i("disk cache initialized; size: " + Utils.formatBytes(0xA00000L));
                    Void void_ = null;
                    return void_;
                }
                catch (DiskLruCache.DiskLruCacheException e) {
                    LOGGER.w("error initializing disk cache, disabling");
                    MemoryAndDiskMetadataCache.this.disableDiskCache();
                    MemoryAndDiskMetadataCache.this.mDiskCacheInitializationLock.notifyAll();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    MemoryAndDiskMetadataCache.this.mDiskCacheInitializationLock.notifyAll();
                    LOGGER.v("releasing disk cache initialization lock: " + Thread.currentThread().toString());
                }
            }
        }
    }
}

