/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.cache;

import android.os.AsyncTask;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.cache.DiskLruCache;
import cz.mzk.tiledimageview.cache.DiskUtils;
import java.io.File;

public class InitDiskCacheTask
extends AsyncTask<File, Void, DiskLruCache> {
    private static final Logger LOGGER = new Logger(InitDiskCacheTask.class);
    private final Object mDiskCacheInitializationLock = new Object();
    private final int appVersion;
    private final boolean clearCache;
    private final int cacheSize;
    private final Listener listener;

    public InitDiskCacheTask(int appVersion, int cacheSize, boolean clearCache, Listener listener) {
        this.appVersion = appVersion;
        this.clearCache = clearCache;
        this.cacheSize = cacheSize;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DiskLruCache doInBackground(File ... params) {
        Object object = this.mDiskCacheInitializationLock;
        synchronized (object) {
            LOGGER.v("assuming mDiskCacheLock: " + Thread.currentThread().toString());
            try {
                File cacheDir = params[0];
                if (cacheDir.exists()) {
                    if (this.clearCache) {
                        LOGGER.i("clearing tiles disk cache");
                        boolean cleared = DiskUtils.deleteDirContent(cacheDir);
                        if (!cleared) {
                            LOGGER.w("failed to delete content of " + cacheDir.getAbsolutePath());
                            DiskLruCache diskLruCache = null;
                            return diskLruCache;
                        }
                    }
                } else {
                    LOGGER.i("creating cache dir " + cacheDir);
                    boolean created = cacheDir.mkdir();
                    if (!created) {
                        LOGGER.e("failed to create cache dir " + cacheDir.getAbsolutePath());
                        DiskLruCache diskLruCache = null;
                        return diskLruCache;
                    }
                }
                DiskLruCache diskLruCache = DiskLruCache.open(cacheDir, this.appVersion, 1, this.cacheSize);
                return diskLruCache;
            }
            catch (DiskLruCache.DiskLruCacheException e) {
                LOGGER.e("error opening disk cache");
                DiskLruCache diskLruCache = null;
                return diskLruCache;
            }
            finally {
                LOGGER.v("releasing disk cache initialization lock: " + Thread.currentThread().toString());
                this.mDiskCacheInitializationLock.notifyAll();
            }
        }
    }

    protected void onPostExecute(DiskLruCache result) {
        if (this.listener != null) {
            if (result != null) {
                this.listener.onFinished(result);
            } else {
                this.listener.onError();
            }
        }
    }

    public static interface Listener {
        public void onError();

        public void onFinished(DiskLruCache var1);
    }
}

