/*
 * Decompiled with CFR 0.152.
 */
package cz.koto.keystorecompat.crypto;

import android.annotation.TargetApi;
import android.security.keystore.KeyNotYetValidException;
import android.security.keystore.UserNotAuthenticatedException;
import android.util.Base64;
import android.util.Log;
import cz.koto.keystorecompat.compat.KeystoreCompatImpl;
import cz.koto.keystorecompat.exception.ForceLockScreenMarshmallowException;
import cz.koto.keystorecompat.exception.KeystoreInvalidKeyException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0010H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcz/koto/keystorecompat/crypto/KeystoreCryptoM;", "", "()V", "LOG_TAG", "", "kotlin.jvm.PlatformType", "ORDER_FOR_ENCRYPTED_DATA", "Ljava/nio/ByteOrder;", "getORDER_FOR_ENCRYPTED_DATA", "()Ljava/nio/ByteOrder;", "decryptAES", "", "secretKeyEntry", "Ljava/security/KeyStore$SecretKeyEntry;", "encryptedSecret", "isBase64Encoded", "", "encryptAES", "secret", "useBase64Encoding", "android-keystore-compat_release"})
public final class KeystoreCryptoM {
    private static final String LOG_TAG;
    private static final ByteOrder ORDER_FOR_ENCRYPTED_DATA;
    public static final KeystoreCryptoM INSTANCE;

    public final ByteOrder getORDER_FOR_ENCRYPTED_DATA() {
        return ORDER_FOR_ENCRYPTED_DATA;
    }

    @TargetApi(value=23)
    @NotNull
    public final String encryptAES(@NotNull byte[] secret, @NotNull KeyStore.SecretKeyEntry secretKeyEntry, boolean useBase64Encoding) {
        byte[] iv;
        byte[] encryptedKeyForRealm;
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        Intrinsics.checkParameterIsNotNull((Object)secretKeyEntry, (String)"secretKeyEntry");
        try {
            SecretKey key = secretKeyEntry.getSecretKey();
            Cipher inCipher = Cipher.getInstance(KeystoreCompatImpl.INSTANCE.getKeystoreCompat().getCipherMode());
            inCipher.init(1, key);
            byte[] byArray = inCipher.doFinal(secret);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"inCipher.doFinal(secret)");
            encryptedKeyForRealm = byArray;
            byte[] byArray2 = inCipher.getIV();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"inCipher.iv");
            iv = byArray2;
        }
        catch (KeyNotYetValidException nve) {
            Log.e((String)LOG_TAG, (String)"encryptAES error: key's validity start date is probably in the future", (Throwable)nve);
            throw (Throwable)nve;
        }
        catch (UserNotAuthenticatedException nae) {
            Log.i((String)LOG_TAG, (String)"User probably exceeded setUserAuthenticationValidityDurationSeconds", (Throwable)nae);
            throw (Throwable)new ForceLockScreenMarshmallowException();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Unexpected encryptAES error", (Throwable)e);
            throw (Throwable)e;
        }
        byte[] ivAndEncryptedKey = new byte[32 + iv.length + encryptedKeyForRealm.length];
        ByteBuffer buffer = ByteBuffer.wrap(ivAndEncryptedKey);
        buffer.order(ORDER_FOR_ENCRYPTED_DATA);
        buffer.putInt(iv.length);
        buffer.put(iv);
        buffer.put(encryptedKeyForRealm);
        if (useBase64Encoding) {
            String string2 = Base64.encodeToString((byte[])ivAndEncryptedKey, (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.encodeToString(iv\u2026yptedKey, Base64.DEFAULT)");
            return string2;
        }
        Charset charset = Charsets.UTF_8;
        return new String(ivAndEncryptedKey, charset);
    }

    @TargetApi(value=23)
    @NotNull
    public final byte[] decryptAES(@NotNull KeyStore.SecretKeyEntry secretKeyEntry, @NotNull String encryptedSecret, boolean isBase64Encoded) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)secretKeyEntry, (String)"secretKeyEntry");
        Intrinsics.checkParameterIsNotNull((Object)encryptedSecret, (String)"encryptedSecret");
        if (isBase64Encoded) {
            byte[] byArray2 = Base64.decode((String)encryptedSecret, (int)0);
            byArray = byArray2;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"Base64.decode(encryptedSecret, Base64.DEFAULT)");
        } else {
            String string2 = encryptedSecret;
            Charset charset = Charsets.UTF_8;
            byte[] byArray3 = string2.getBytes(charset);
            byArray = byArray3;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        }
        byte[] ivAndEncryptedKey = byArray;
        ByteBuffer buffer = ByteBuffer.wrap(ivAndEncryptedKey);
        buffer.order(ORDER_FOR_ENCRYPTED_DATA);
        int ivLength = buffer.getInt();
        byte[] iv = new byte[ivLength];
        byte[] encryptedKey = new byte[ivAndEncryptedKey.length - 32 - ivLength];
        buffer.get(iv);
        buffer.get(encryptedKey);
        try {
            Cipher cipher = Cipher.getInstance(KeystoreCompatImpl.INSTANCE.getKeystoreCompat().getCipherMode());
            GCMParameterSpec ivSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)secretKeyEntry.getSecretKey(), ivSpec);
            byte[] byArray4 = cipher.doFinal(encryptedKey);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"cipher.doFinal(encryptedKey)");
            return byArray4;
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof InvalidKeyException) {
                throw (Throwable)new KeystoreInvalidKeyException();
            }
            if (exception instanceof UnrecoverableKeyException || exception instanceof NoSuchAlgorithmException || exception instanceof BadPaddingException || exception instanceof KeyStoreException || exception instanceof IllegalBlockSizeException || exception instanceof InvalidAlgorithmParameterException) {
                // empty if block
            }
            Log.e((String)LOG_TAG, (String)"decryptAES error", (Throwable)e);
            throw (Throwable)e;
        }
    }

    private KeystoreCryptoM() {
        INSTANCE = this;
        LOG_TAG = this.getClass().getName();
        ORDER_FOR_ENCRYPTED_DATA = ByteOrder.BIG_ENDIAN;
    }

    static {
        new KeystoreCryptoM();
    }
}

