/*
 * Decompiled with CFR 0.152.
 */
package cz.koto.keystorecompat.crypto;

import android.annotation.TargetApi;
import android.util.Base64;
import android.util.Log;
import cz.koto.keystorecompat.compat.KeystoreCompatImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\fH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcz/koto/keystorecompat/crypto/KeystoreCryptoK;", "", "()V", "LOG_TAG", "", "kotlin.jvm.PlatformType", "decryptRSA", "", "privateKeyEntry", "Ljava/security/KeyStore$PrivateKeyEntry;", "encryptedSecret", "isBase64Encoded", "", "encryptRSA", "secret", "useBase64Encoding", "android-keystore-compat_release"})
public final class KeystoreCryptoK {
    private static final String LOG_TAG;
    public static final KeystoreCryptoK INSTANCE;

    @TargetApi(value=19)
    @NotNull
    public final String encryptRSA(@NotNull byte[] secret, @NotNull KeyStore.PrivateKeyEntry privateKeyEntry, boolean useBase64Encoding) {
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        Intrinsics.checkParameterIsNotNull((Object)privateKeyEntry, (String)"privateKeyEntry");
        try {
            PublicKey publicKey = privateKeyEntry.getCertificate().getPublicKey();
            if (publicKey == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
            }
            RSAPublicKey publicKey2 = (RSAPublicKey)publicKey;
            Cipher inCipher = Cipher.getInstance(KeystoreCompatImpl.INSTANCE.getKeystoreCompat().getCipherMode());
            inCipher.init(1, publicKey2);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, inCipher);
            cipherOutputStream.write(secret);
            cipherOutputStream.close();
            if (useBase64Encoding) {
                String string2 = Base64.encodeToString((byte[])outputStream.toByteArray(), (int)0);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.encodeToString(ou\u2026eArray(), Base64.DEFAULT)");
                return string2;
            }
            byte[] byArray = outputStream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"outputStream.toByteArray()");
            byte[] byArray2 = byArray;
            Charset charset = Charsets.UTF_8;
            return new String(byArray2, charset);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"encryptRSA error", (Throwable)e);
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=19)
    @NotNull
    public final byte[] decryptRSA(@NotNull KeyStore.PrivateKeyEntry privateKeyEntry, @NotNull String encryptedSecret, boolean isBase64Encoded) {
        Intrinsics.checkParameterIsNotNull((Object)privateKeyEntry, (String)"privateKeyEntry");
        Intrinsics.checkParameterIsNotNull((Object)encryptedSecret, (String)"encryptedSecret");
        try {
            void nextByte;
            byte[] byArray;
            if (isBase64Encoded) {
                byte[] byArray2 = Base64.decode((String)encryptedSecret, (int)0);
                byArray = byArray2;
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"Base64.decode(encryptedSecret, Base64.DEFAULT)");
            } else {
                String string2 = encryptedSecret;
                Charset charset = Charsets.UTF_8;
                byte[] byArray3 = string2.getBytes(charset);
                byArray = byArray3;
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
            }
            byte[] inputByteArray = byArray;
            Cipher output = Cipher.getInstance(KeystoreCompatImpl.INSTANCE.getKeystoreCompat().getCipherMode());
            output.init(2, privateKeyEntry.getPrivateKey());
            CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(inputByteArray), output);
            ArrayList<Byte> values = new ArrayList<Byte>();
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = -1;
            while (((Number)((Function0)new Function0<Integer>((Ref.IntRef)nextByte, cipherInputStream){
                final /* synthetic */ Ref.IntRef $nextByte;
                final /* synthetic */ CipherInputStream $cipherInputStream;

                public final int invoke() {
                    this.$nextByte.element = this.$cipherInputStream.read();
                    return this.$nextByte.element;
                }
                {
                    this.$nextByte = intRef;
                    this.$cipherInputStream = cipherInputStream;
                    super(0);
                }
            }).invoke()).intValue() != -1) {
                values.add((byte)nextByte.element);
            }
            byte[] bytes = new byte[values.size()];
            int n = 0;
            int n2 = bytes.length;
            while (n < n2) {
                void i;
                Object e = values.get((int)i);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"values[i]");
                bytes[i] = ((Number)e).byteValue();
                ++i;
            }
            return bytes;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"decryptRSA error", (Throwable)e);
            throw (Throwable)e;
        }
    }

    private KeystoreCryptoK() {
        INSTANCE = this;
        LOG_TAG = this.getClass().getName();
    }

    static {
        new KeystoreCryptoK();
    }
}

