/*
 * Decompiled with CFR 0.152.
 */
package cz.koto.keystorecompat.compat;

import android.annotation.TargetApi;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore.UserNotAuthenticatedException;
import android.util.Log;
import cz.koto.keystorecompat.KeystoreCompat;
import cz.koto.keystorecompat.compat.KeystoreCompatFacade;
import cz.koto.keystorecompat.compat.KeystoreCompatImpl;
import cz.koto.keystorecompat.crypto.KeystoreCryptoM;
import cz.koto.keystorecompat.exception.KeystoreInvalidKeyException;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Date;
import javax.crypto.KeyGenerator;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0087\u0001\u0010\u0018\u001a\u00020\u00072!\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00070\u001a2%\u0010\u001f\u001a!\u0012\u0017\u0012\u00150 j\u0002`!\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00070\u001a2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$2\b\u0010%\u001a\u0004\u0018\u00010\u00172\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010*J \u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u0017H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcz/koto/keystorecompat/compat/KeystoreCompatM;", "Lcz/koto/keystorecompat/compat/KeystoreCompatFacade;", "()V", "LOG_TAG", "", "kotlin.jvm.PlatformType", "generateKeyPair", "", "alias", "start", "Ljava/util/Date;", "end", "certSubject", "Ljavax/security/auth/x500/X500Principal;", "context", "Landroid/content/Context;", "getAlgorithm", "getAlgorithmParameterSpec", "Ljava/security/spec/AlgorithmParameterSpec;", "startDate", "endDate", "getCipherMode", "isSecurityEnabled", "", "loadSecret", "onSuccess", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "cre", "onFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "e", "clearCredentials", "Lkotlin/Function0;", "forceFlag", "encryptedUserData", "keyEntry", "Ljava/security/KeyStore$Entry;", "isBase64Encoded", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Ljava/lang/Boolean;Ljava/lang/String;Ljava/security/KeyStore$Entry;Z)V", "storeSecret", "secret", "privateKeyEntry", "useBase64Encoding", "android-keystore-compat_release"})
@TargetApi(value=23)
public final class KeystoreCompatM
implements KeystoreCompatFacade {
    private static final String LOG_TAG;
    public static final KeystoreCompatM INSTANCE;

    @Override
    @NotNull
    public String getAlgorithm() {
        return "AES";
    }

    @Override
    @NotNull
    public String getCipherMode() {
        return "AES/GCM/NoPadding";
    }

    @Override
    @NotNull
    public String storeSecret(@NotNull byte[] secret, @NotNull KeyStore.Entry privateKeyEntry, boolean useBase64Encoding) {
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        Intrinsics.checkParameterIsNotNull((Object)privateKeyEntry, (String)"privateKeyEntry");
        return KeystoreCryptoM.INSTANCE.encryptAES(secret, (KeyStore.SecretKeyEntry)privateKeyEntry, useBase64Encoding);
    }

    @Override
    public void loadSecret(@NotNull Function1<? super byte[], Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure, @NotNull Function0<Unit> clearCredentials, @Nullable Boolean forceFlag, @NotNull String encryptedUserData, @NotNull KeyStore.Entry keyEntry, boolean isBase64Encoded) {
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onFailure, (String)"onFailure");
        Intrinsics.checkParameterIsNotNull(clearCredentials, (String)"clearCredentials");
        Intrinsics.checkParameterIsNotNull((Object)encryptedUserData, (String)"encryptedUserData");
        Intrinsics.checkParameterIsNotNull((Object)keyEntry, (String)"keyEntry");
        try {
            if (forceFlag == null || forceFlag.booleanValue()) {
                onFailure.invoke((Object)new RuntimeException("Force flag enabled!"));
            } else {
                onSuccess.invoke((Object)KeystoreCryptoM.INSTANCE.decryptAES((KeyStore.SecretKeyEntry)keyEntry, encryptedUserData, isBase64Encoded));
            }
        }
        catch (UserNotAuthenticatedException e) {
            onFailure.invoke((Object)e);
        }
        catch (KeyPermanentlyInvalidatedException e) {
            Log.w((String)LOG_TAG, (String)"KeyPermanentlyInvalidatedException: cleanUp credentials for storage!");
            clearCredentials.invoke();
            onFailure.invoke((Object)e);
        }
        catch (KeystoreInvalidKeyException e) {
            Log.w((String)LOG_TAG, (String)"KeystoreInvalidKeyException: user might dismiss lockScreen.");
            onFailure.invoke((Object)e);
        }
        catch (Exception e) {
            onFailure.invoke((Object)e);
        }
    }

    @Override
    @NotNull
    public AlgorithmParameterSpec getAlgorithmParameterSpec(@NotNull X500Principal certSubject, @NotNull String alias, @NotNull Date startDate, @NotNull Date endDate, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)certSubject, (String)"certSubject");
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)startDate, (String)"startDate");
        Intrinsics.checkParameterIsNotNull((Object)endDate, (String)"endDate");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 23) {
            throw (Throwable)new RuntimeException("" + LOG_TAG + " Unsupported usage of version " + Build.VERSION.SDK_INT);
        }
        KeyGenParameterSpec keyGenParameterSpec = new KeyGenParameterSpec.Builder(alias, 1 | 2).setBlockModes(new String[]{"GCM"}).setCertificateSubject(certSubject).setKeyValidityStart(startDate).setKeyValidityEnd(endDate).setDigests(new String[]{"SHA-512"}).setEncryptionPaddings(new String[]{"NoPadding"}).setAlgorithmParameterSpec((AlgorithmParameterSpec)new RSAKeyGenParameterSpec(512, RSAKeyGenParameterSpec.F4)).setUserAuthenticationRequired(KeystoreCompat.INSTANCE.getConfig().getUserAuthenticationRequired()).setUserAuthenticationValidityDurationSeconds(KeystoreCompat.INSTANCE.getConfig().getUserAuthenticationValidityDurationSeconds()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyGenParameterSpec, (String)"KeyGenParameterSpec.Buil\u2026onSeconds())\n\t\t\t\t.build()");
        return (AlgorithmParameterSpec)keyGenParameterSpec;
    }

    @Override
    public boolean isSecurityEnabled(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("keyguard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.KeyguardManager");
        }
        KeyguardManager km = (KeyguardManager)object;
        Log.d((String)LOG_TAG, (String)("DEVICE-SECURE:" + km.isDeviceSecure()));
        Log.d((String)LOG_TAG, (String)("DEVICE-LOCKED:" + km.isDeviceLocked()));
        Log.d((String)LOG_TAG, (String)("KEYGUARD-SECURE:" + km.isKeyguardSecure()));
        Log.d((String)LOG_TAG, (String)("KEYGUARD-LOCKED:" + km.isKeyguardLocked()));
        return km.isDeviceSecure();
    }

    @Override
    public void generateKeyPair(@NotNull String alias, @NotNull Date start, @NotNull Date end, @NotNull X500Principal certSubject, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)certSubject, (String)"certSubject");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KeyGenerator generator = KeyGenerator.getInstance(KeystoreCompatImpl.INSTANCE.getKeystoreCompat().getAlgorithm(), KeystoreCompat.INSTANCE.getKEYSTORE_KEYWORD());
        generator.init(this.getAlgorithmParameterSpec(certSubject, alias, start, end, context));
        generator.generateKey();
    }

    private KeystoreCompatM() {
        INSTANCE = this;
        LOG_TAG = this.getClass().getName();
    }

    static {
        new KeystoreCompatM();
    }
}

