/*
 * Decompiled with CFR 0.152.
 */
package cz.koto.keystorecompat.compat;

import android.annotation.TargetApi;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.util.Log;
import cz.koto.keystorecompat.KeystoreCompat;
import cz.koto.keystorecompat.compat.KeystoreCompatFacade;
import cz.koto.keystorecompat.compat.KeystoreCompatImpl;
import cz.koto.keystorecompat.crypto.KeystoreCryptoK;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016Ji\u0010\u0018\u001a\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00070\u001a2\u0016\u0010\u001c\u001a\u0012\u0012\b\u0012\u00060\u001dj\u0002`\u001e\u0012\u0004\u0012\u00020\u00070\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 2\b\u0010!\u001a\u0004\u0018\u00010\u00172\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010&J \u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u0017H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcz/koto/keystorecompat/compat/KeystoreCompatL;", "Lcz/koto/keystorecompat/compat/KeystoreCompatFacade;", "()V", "LOG_TAG", "", "kotlin.jvm.PlatformType", "generateKeyPair", "", "alias", "start", "Ljava/util/Date;", "end", "certSubject", "Ljavax/security/auth/x500/X500Principal;", "context", "Landroid/content/Context;", "getAlgorithm", "getAlgorithmParameterSpec", "Ljava/security/spec/AlgorithmParameterSpec;", "startDate", "endDate", "getCipherMode", "isSecurityEnabled", "", "loadSecret", "onSuccess", "Lkotlin/Function1;", "", "onFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "clearCredentials", "Lkotlin/Function0;", "forceFlag", "encryptedUserData", "keyEntry", "Ljava/security/KeyStore$Entry;", "isBase64Encoded", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Ljava/lang/Boolean;Ljava/lang/String;Ljava/security/KeyStore$Entry;Z)V", "storeSecret", "secret", "privateKeyEntry", "useBase64Encoding", "android-keystore-compat_release"})
@TargetApi(value=21)
public final class KeystoreCompatL
implements KeystoreCompatFacade {
    private static final String LOG_TAG;
    public static final KeystoreCompatL INSTANCE;

    @Override
    @NotNull
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    @NotNull
    public String getCipherMode() {
        return "RSA/None/PKCS1Padding";
    }

    @Override
    @NotNull
    public String storeSecret(@NotNull byte[] secret, @NotNull KeyStore.Entry privateKeyEntry, boolean useBase64Encoding) {
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        Intrinsics.checkParameterIsNotNull((Object)privateKeyEntry, (String)"privateKeyEntry");
        return KeystoreCryptoK.INSTANCE.encryptRSA(secret, (KeyStore.PrivateKeyEntry)privateKeyEntry, useBase64Encoding);
    }

    @Override
    public void loadSecret(@NotNull Function1<? super byte[], Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure, @NotNull Function0<Unit> clearCredentials, @Nullable Boolean forceFlag, @NotNull String encryptedUserData, @NotNull KeyStore.Entry keyEntry, boolean isBase64Encoded) {
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onFailure, (String)"onFailure");
        Intrinsics.checkParameterIsNotNull(clearCredentials, (String)"clearCredentials");
        Intrinsics.checkParameterIsNotNull((Object)encryptedUserData, (String)"encryptedUserData");
        Intrinsics.checkParameterIsNotNull((Object)keyEntry, (String)"keyEntry");
        try {
            if (forceFlag == null || forceFlag.booleanValue()) {
                onFailure.invoke((Object)new RuntimeException("Force flag enabled!"));
            } else {
                onSuccess.invoke((Object)KeystoreCryptoK.INSTANCE.decryptRSA((KeyStore.PrivateKeyEntry)keyEntry, encryptedUserData, isBase64Encoded));
            }
        }
        catch (Exception e) {
            onFailure.invoke((Object)e);
        }
    }

    @Override
    @NotNull
    public AlgorithmParameterSpec getAlgorithmParameterSpec(@NotNull X500Principal certSubject, @NotNull String alias, @NotNull Date startDate, @NotNull Date endDate, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)certSubject, (String)"certSubject");
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)startDate, (String)"startDate");
        Intrinsics.checkParameterIsNotNull((Object)endDate, (String)"endDate");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 21) {
            throw (Throwable)new RuntimeException("" + LOG_TAG + " Unsupported usage of version " + Build.VERSION.SDK_INT);
        }
        KeyPairGeneratorSpec keyPairGeneratorSpec = new KeyPairGeneratorSpec.Builder(context).setAlias(alias).setSubject(certSubject).setSerialNumber(BigInteger.ONE).setStartDate(startDate).setEndDate(endDate).setEncryptionRequired().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyPairGeneratorSpec, (String)"KeyPairGeneratorSpec.Bui\u2026ge exception\n\t\t\t\t.build()");
        return (AlgorithmParameterSpec)keyPairGeneratorSpec;
    }

    @Override
    public boolean isSecurityEnabled(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("keyguard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.KeyguardManager");
        }
        KeyguardManager km = (KeyguardManager)object;
        Log.d((String)LOG_TAG, (String)("KEYGUARD-SECURE:%s" + km.isKeyguardSecure()));
        Log.d((String)LOG_TAG, (String)("KEYGUARD-LOCKED:%s" + km.isKeyguardLocked()));
        return km.isKeyguardSecure();
    }

    @Override
    public void generateKeyPair(@NotNull String alias, @NotNull Date start, @NotNull Date end, @NotNull X500Principal certSubject, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)certSubject, (String)"certSubject");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KeyPairGenerator generator = KeyPairGenerator.getInstance(KeystoreCompatImpl.INSTANCE.getKeystoreCompat().getAlgorithm(), KeystoreCompat.INSTANCE.getKEYSTORE_KEYWORD());
        generator.initialize(this.getAlgorithmParameterSpec(certSubject, alias, start, end, context));
        generator.generateKeyPair();
    }

    private KeystoreCompatL() {
        INSTANCE = this;
        LOG_TAG = this.getClass().getName();
    }

    static {
        new KeystoreCompatL();
    }
}

