/*
 * Decompiled with CFR 0.152.
 */
package cz.koto.keystorecompat;

import android.util.Log;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0001H\u0087\b\u001a3\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0001H\u0087\b\u001a\t\u0010\u0014\u001a\u00020\rH\u0086\b\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0014\u0010\n\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"LENGTH32BYTES", "", "getLENGTH32BYTES", "()I", "LENGTH64BYTES", "getLENGTH64BYTES", "PBKDF2WithHmacSHA1", "", "getPBKDF2WithHmacSHA1", "()Ljava/lang/String;", "PBKDF2WithHmacSHA512", "getPBKDF2WithHmacSHA512", "createHashKey", "", "basePassword", "sha512", "", "keyLengthInBit", "salt", "iterationCount", "createRandomHashKey", "android-keystore-compat_release"})
public final class KeystoreHashKt {
    @NotNull
    private static final String PBKDF2WithHmacSHA512 = "PBKDF2WithHmacSHA512";
    @NotNull
    private static final String PBKDF2WithHmacSHA1 = "PBKDF2WithHmacSHA1";
    private static final int LENGTH32BYTES = 256;
    private static final int LENGTH64BYTES = 512;

    @NotNull
    public static final String getPBKDF2WithHmacSHA512() {
        return PBKDF2WithHmacSHA512;
    }

    @NotNull
    public static final String getPBKDF2WithHmacSHA1() {
        return PBKDF2WithHmacSHA1;
    }

    public static final int getLENGTH32BYTES() {
        return LENGTH32BYTES;
    }

    public static final int getLENGTH64BYTES() {
        return LENGTH64BYTES;
    }

    @NotNull
    public static final byte[] createRandomHashKey() {
        int KEY_LENGTH = 64;
        byte[] key = new byte[KEY_LENGTH];
        SecureRandom rng = new SecureRandom();
        rng.nextBytes(key);
        return key;
    }

    @JvmOverloads
    @NotNull
    public static final byte[] createHashKey(@NotNull String basePassword, @NotNull byte[] salt, int iterationCount, boolean sha512, int keyLengthInBit) {
        Intrinsics.checkParameterIsNotNull((Object)basePassword, (String)"basePassword");
        Intrinsics.checkParameterIsNotNull((Object)salt, (String)"salt");
        try {
            PBEKeySpec pBEKeySpec;
            SecretKeyFactory skf = SecretKeyFactory.getInstance(sha512 ? KeystoreHashKt.getPBKDF2WithHmacSHA512() : KeystoreHashKt.getPBKDF2WithHmacSHA1());
            String string = basePassword;
            PBEKeySpec pBEKeySpec2 = pBEKeySpec;
            PBEKeySpec pBEKeySpec3 = pBEKeySpec;
            char[] cArray = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] cArray2 = cArray;
            pBEKeySpec2(cArray2, salt, iterationCount, keyLengthInBit);
            PBEKeySpec spec = pBEKeySpec3;
            SecretKey key = skf.generateSecret(spec);
            byte[] byArray = key.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"key.encoded");
            return byArray;
        }
        catch (Exception e) {
            Log.e((String)"KeystoreHash", (String)"Unable to create hash key!", (Throwable)e);
            throw (Throwable)e;
        }
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ byte[] createHashKey$default(String basePassword, byte[] salt, int iterationCount, boolean sha512, int keyLengthInBit, int n, Object object) {
        if ((n & 0x10) != 0) {
            keyLengthInBit = KeystoreHashKt.getLENGTH32BYTES();
        }
        Intrinsics.checkParameterIsNotNull((Object)basePassword, (String)"basePassword");
        Intrinsics.checkParameterIsNotNull((Object)salt, (String)"salt");
        try {
            PBEKeySpec pBEKeySpec;
            SecretKeyFactory skf = SecretKeyFactory.getInstance(sha512 ? KeystoreHashKt.getPBKDF2WithHmacSHA512() : KeystoreHashKt.getPBKDF2WithHmacSHA1());
            String string = basePassword;
            PBEKeySpec pBEKeySpec2 = pBEKeySpec;
            PBEKeySpec pBEKeySpec3 = pBEKeySpec;
            char[] cArray = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] cArray2 = cArray;
            pBEKeySpec2(cArray2, salt, iterationCount, keyLengthInBit);
            PBEKeySpec spec = pBEKeySpec3;
            SecretKey key = skf.generateSecret(spec);
            byte[] byArray = key.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"key.encoded");
            return byArray;
        }
        catch (Exception e) {
            Log.e((String)"KeystoreHash", (String)"Unable to create hash key!", (Throwable)e);
            throw (Throwable)e;
        }
    }

    @JvmOverloads
    @NotNull
    public static final byte[] createHashKey(@NotNull String basePassword, @NotNull byte[] salt, int iterationCount, boolean sha512) {
        return KeystoreHashKt.createHashKey$default(basePassword, salt, iterationCount, sha512, 0, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static final byte[] createHashKey(@NotNull String basePassword, boolean sha512, int keyLengthInBit) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)basePassword, (String)"basePassword");
        Object object = basePassword;
        Charset charset = Charset.forName("UTF-32");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"UTF-32\")");
        Charset charset2 = charset;
        byte[] byArray2 = ((String)object).getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray2;
        int iterationCount$iv = basePassword.length();
        try {
            void salt$iv;
            PBEKeySpec pBEKeySpec;
            SecretKeyFactory skf$iv = SecretKeyFactory.getInstance(sha512 ? KeystoreHashKt.getPBKDF2WithHmacSHA512() : KeystoreHashKt.getPBKDF2WithHmacSHA1());
            String string = basePassword;
            PBEKeySpec pBEKeySpec2 = pBEKeySpec;
            PBEKeySpec pBEKeySpec3 = pBEKeySpec;
            char[] cArray = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] cArray2 = cArray;
            pBEKeySpec2(cArray2, (byte[])salt$iv, iterationCount$iv, keyLengthInBit);
            PBEKeySpec spec$iv = pBEKeySpec3;
            SecretKey key$iv = skf$iv.generateSecret(spec$iv);
            byte[] byArray3 = key$iv.getEncoded();
            byArray = byArray3;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"key.encoded");
        }
        catch (Exception e$iv) {
            Log.e((String)"KeystoreHash", (String)"Unable to create hash key!", (Throwable)e$iv);
            throw (Throwable)e$iv;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ byte[] createHashKey$default(String basePassword, boolean sha512, int keyLengthInBit, int n, Object object) {
        byte[] byArray;
        if ((n & 4) != 0) {
            keyLengthInBit = KeystoreHashKt.getLENGTH32BYTES();
        }
        Intrinsics.checkParameterIsNotNull((Object)basePassword, (String)"basePassword");
        object = basePassword;
        Charset charset = Charset.forName("UTF-32");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"UTF-32\")");
        Charset charset2 = charset;
        byte[] byArray2 = ((String)object).getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray2;
        int iterationCount$iv = basePassword.length();
        try {
            void salt$iv;
            PBEKeySpec pBEKeySpec;
            SecretKeyFactory skf$iv = SecretKeyFactory.getInstance(sha512 ? KeystoreHashKt.getPBKDF2WithHmacSHA512() : KeystoreHashKt.getPBKDF2WithHmacSHA1());
            String string = basePassword;
            PBEKeySpec pBEKeySpec2 = pBEKeySpec;
            PBEKeySpec pBEKeySpec3 = pBEKeySpec;
            char[] cArray = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] cArray2 = cArray;
            pBEKeySpec2(cArray2, (byte[])salt$iv, iterationCount$iv, keyLengthInBit);
            PBEKeySpec spec$iv = pBEKeySpec3;
            SecretKey key$iv = skf$iv.generateSecret(spec$iv);
            byte[] byArray3 = key$iv.getEncoded();
            byArray = byArray3;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"key.encoded");
        }
        catch (Exception e$iv) {
            Log.e((String)"KeystoreHash", (String)"Unable to create hash key!", (Throwable)e$iv);
            throw (Throwable)e$iv;
        }
        return byArray;
    }

    @JvmOverloads
    @NotNull
    public static final byte[] createHashKey(@NotNull String basePassword, boolean sha512) {
        return KeystoreHashKt.createHashKey$default(basePassword, sha512, 0, 4, null);
    }

    static {
        PBKDF2WithHmacSHA512 = PBKDF2WithHmacSHA512;
        PBKDF2WithHmacSHA1 = PBKDF2WithHmacSHA1;
        LENGTH32BYTES = 256;
        LENGTH64BYTES = 512;
    }
}

