/*
 * Decompiled with CFR 0.152.
 */
package cz.kinst.jakub.viewmodelbinding;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import cz.kinst.jakub.viewmodelbinding.ViewModel;
import java.util.HashMap;
import java.util.Map;

public class PermissionsManager {
    private static final int RC_PERMISSIONS = 62538;
    ViewModel mViewModel;
    private PermissionCallback mCallback;

    PermissionsManager(ViewModel viewModel) {
        this.mViewModel = viewModel;
    }

    public void checkOrRequestPermissions(String permission, PermissionCallback callback) {
        this.checkOrRequestPermissions(new String[]{permission}, callback);
    }

    public void checkOrRequestPermissions(String[] permissions, PermissionCallback callback) {
        PermissionsResult result = this.checkPermissions(permissions);
        if (result.isGranted()) {
            callback.onPermissionsResult(result);
        } else {
            this.requestPermissions(permissions, callback);
        }
    }

    public boolean shouldShowRequestPermissionRationale(String permission) {
        if (this.mViewModel.getView() instanceof Fragment) {
            return ((Fragment)this.mViewModel.getView()).shouldShowRequestPermissionRationale(permission);
        }
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.mViewModel.getActivity(), (String)permission);
    }

    public PermissionsResult checkPermissions(String ... permissions) {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        for (String permission : permissions) {
            int result = ContextCompat.checkSelfPermission((Context)this.mViewModel.getApplicationContext(), (String)permission);
            results.put(permission, result == 0);
        }
        return new PermissionsResult(results);
    }

    public void requestPermissions(String permission, PermissionCallback callback) {
        this.requestPermissions(new String[]{permission}, callback);
    }

    public void requestPermissions(String[] permissions, PermissionCallback callback) {
        this.mCallback = callback;
        if (this.mViewModel.getView() instanceof Fragment) {
            ((Fragment)this.mViewModel.getView()).requestPermissions(permissions, 62538);
        } else {
            ActivityCompat.requestPermissions((Activity)this.mViewModel.getActivity(), (String[])permissions, (int)62538);
        }
    }

    public Intent getApplicationPermissionSettingsIntent() {
        Intent intent = new Intent();
        intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.mViewModel.getApplicationContext().getPackageName(), null);
        intent.setData(uri);
        return intent;
    }

    void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 62538 && this.mCallback != null) {
            this.mCallback.onPermissionsResult(new PermissionsResult(permissions, grantResults));
            this.mCallback = null;
        }
    }

    public class PermissionsResult {
        Map<String, Boolean> mResult;

        private PermissionsResult(Map<String, Boolean> result) {
            this.mResult = result;
        }

        private PermissionsResult(String[] permissions, int[] grantResults) {
            this.mResult = new HashMap<String, Boolean>();
            for (int i = 0; i < permissions.length; ++i) {
                this.mResult.put(permissions[i], grantResults[i] == 0);
            }
        }

        public boolean isGranted() {
            String[] permissionsArray = this.mResult.keySet().toArray(new String[this.mResult.keySet().size()]);
            return this.isGranted(permissionsArray);
        }

        public boolean isGranted(String ... permissions) {
            for (String permission : permissions) {
                if (this.mResult.get(permission).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Map<String, Boolean> getResultsMap() {
            return new HashMap<String, Boolean>(this.mResult);
        }
    }

    public static interface PermissionCallback {
        public void onPermissionsResult(PermissionsResult var1);
    }
}

