/*
 * Decompiled with CFR 0.152.
 */
package cz.kinst.jakub.viewmodelbinding;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.databinding.BaseObservable;
import android.databinding.ViewDataBinding;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.CallSuper;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.view.View;
import cz.kinst.jakub.viewmodelbinding.ViewInterface;
import cz.kinst.jakub.viewmodelbinding.ViewModel$$Lambda$1;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class ViewModel<T extends ViewDataBinding>
extends BaseObservable {
    private ViewInterface<T, ? extends ViewModel> mView;
    private String mViewModelId;
    private Handler mHandler = new Handler();
    private Thread mUiThread;
    private boolean mRunning;
    private Queue<Runnable> mUiThreadTaskQueue = new ConcurrentLinkedQueue<Runnable>();

    @CallSuper
    public void onResume() {
        this.mRunning = true;
    }

    @CallSuper
    public void onPause() {
        this.mRunning = false;
    }

    public boolean isRunning() {
        return this.hasViewAttached() && this.mRunning;
    }

    @CallSuper
    public void onViewDetached(boolean finalDetachment) {
        this.mView = null;
    }

    @CallSuper
    public void onViewAttached(boolean firstAttachment) {
    }

    @CallSuper
    public void onViewModelDestroyed() {
        this.mView = null;
        this.mUiThreadTaskQueue.clear();
    }

    public ViewInterface<T, ? extends ViewModel> getView() {
        return this.mView;
    }

    public Context getContext() {
        if (this.mView == null) {
            return null;
        }
        return this.mView.getContext();
    }

    public Activity getActivity() {
        if (this.mView == null) {
            return null;
        }
        return this.mView.getActivity();
    }

    public boolean hasViewAttached() {
        return this.mView != null;
    }

    public String getViewModelId() {
        return this.mViewModelId;
    }

    void setViewModelId(String viewModelId) {
        this.mViewModelId = viewModelId;
    }

    @CallSuper
    public void onViewModelCreated() {
        this.mUiThread = Thread.currentThread();
    }

    public T getBinding() {
        if (this.hasViewAttached()) {
            return this.getView().getBinding();
        }
        return null;
    }

    public View getRootView() {
        return this.getBinding().getRoot();
    }

    public final void runOnUiThread(Runnable action) {
        this.internalRunOnUiThreadNow(action);
    }

    public void postDelayed(Runnable runnable, long delayMs) {
        this.mHandler.postDelayed(runnable, delayMs);
    }

    protected void bindView(ViewInterface<T, ? extends ViewModel> viewInterface) {
        this.mView = viewInterface;
    }

    protected Resources getResources() {
        if (this.getContext() == null) {
            return null;
        }
        return this.getContext().getResources();
    }

    protected String getString(@StringRes int resource) {
        if (this.getContext() == null) {
            return null;
        }
        return this.getContext().getString(resource);
    }

    protected String getString(@StringRes int resource, Object ... formatArgs) {
        if (this.getContext() == null) {
            return null;
        }
        return this.getContext().getString(resource, formatArgs);
    }

    protected Drawable getDrawable(@DrawableRes int resource) {
        if (this.getContext() == null) {
            return null;
        }
        return ContextCompat.getDrawable((Context)this.getContext(), (int)resource);
    }

    protected int getColor(@ColorRes int resource) {
        if (this.getContext() == null) {
            return -1;
        }
        return ContextCompat.getColor((Context)this.getContext(), (int)resource);
    }

    void internalRunAllUiTasksInQueue() {
        while (!this.mUiThreadTaskQueue.isEmpty()) {
            this.internalRunOnUiThreadNow(this.mUiThreadTaskQueue.poll());
        }
    }

    private void internalRunOnUiThreadNow(Runnable action) {
        if (Thread.currentThread() != this.mUiThread) {
            this.mHandler.post(ViewModel$$Lambda$1.lambdaFactory$(this, action));
        } else if (this.hasViewAttached()) {
            action.run();
        } else {
            this.mUiThreadTaskQueue.add(action);
        }
    }

    private /* synthetic */ void lambda$internalRunOnUiThreadNow$0(Runnable runnable) {
        if (this.hasViewAttached()) {
            runnable.run();
        } else {
            this.mUiThreadTaskQueue.add(runnable);
        }
    }

    static /* synthetic */ void access$lambda$0(ViewModel viewModel, Runnable runnable) {
        viewModel.lambda$internalRunOnUiThreadNow$0(runnable);
    }
}

