/*
 * Decompiled with CFR 0.152.
 */
package cz.kinst.jakub.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.transition.TransitionManager;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import cz.kinst.jakub.view.StatefulLayout;
import cz.kinst.jakub.view.simple.R;

public class SimpleStatefulLayout
extends StatefulLayout {
    private String mInitialState = "content";
    private boolean mTransitionsEnabled = true;

    public SimpleStatefulLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public SimpleStatefulLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SimpleStatefulLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SflStatefulLayout);
        int offlineLayoutResource = a.getResourceId(R.styleable.SflStatefulLayout_offlineLayout, R.layout.sfl_default_placeholder_offline);
        int emptyLayoutResource = a.getResourceId(R.styleable.SflStatefulLayout_emptyLayout, R.layout.sfl_default_placeholder_empty);
        int progressLayoutResource = a.getResourceId(R.styleable.SflStatefulLayout_progressLayout, R.layout.sfl_default_placeholder_progress);
        this.setStateView("offline", LayoutInflater.from((Context)this.getContext()).inflate(offlineLayoutResource, null));
        this.setStateView("empty", LayoutInflater.from((Context)this.getContext()).inflate(emptyLayoutResource, null));
        this.setStateView("progress", LayoutInflater.from((Context)this.getContext()).inflate(progressLayoutResource, null));
        int textAppearance = a.getResourceId(R.styleable.SflStatefulLayout_stateTextAppearance, R.style.sfl_TextAppearanceStateDefault);
        this.setTextAppearance(textAppearance);
        if (a.hasValue(R.styleable.SflStatefulLayout_emptyText)) {
            this.setEmptyText(a.getString(R.styleable.SflStatefulLayout_emptyText));
        }
        if (a.hasValue(R.styleable.SflStatefulLayout_offlineText)) {
            this.setOfflineText(a.getString(R.styleable.SflStatefulLayout_offlineText));
        }
        if (a.hasValue(R.styleable.SflStatefulLayout_offlineRetryText)) {
            this.setOfflineText(a.getString(R.styleable.SflStatefulLayout_offlineRetryText));
        }
        if (a.hasValue(R.styleable.SflStatefulLayout_offlineImageDrawable)) {
            this.setOfflineImageResource(a.getResourceId(R.styleable.SflStatefulLayout_offlineImageDrawable, 0));
        }
        if (a.hasValue(R.styleable.SflStatefulLayout_emptyImageDrawable)) {
            this.setEmptyImageResource(a.getResourceId(R.styleable.SflStatefulLayout_emptyImageDrawable, 0));
        }
        if (a.hasValue(R.styleable.SflStatefulLayout_state)) {
            this.mInitialState = a.getString(R.styleable.SflStatefulLayout_state);
        }
        a.recycle();
    }

    protected void onSetupContentState() {
        super.onSetupContentState();
        if (this.mInitialState != null) {
            this.setState(this.mInitialState);
        }
    }

    public void showContent() {
        this.setState("content");
    }

    public void showProgress() {
        this.setState("progress");
    }

    public void showOffline() {
        this.setState("offline");
    }

    public void showEmpty() {
        this.setState("empty");
    }

    public void setTextAppearance(int textAppearance) {
        TextView offlineTextView = (TextView)this.getOfflineView().findViewById(R.id.state_text);
        offlineTextView.setTextAppearance(this.getContext(), textAppearance);
        TextView emptyTextView = (TextView)this.getEmptyView().findViewById(R.id.state_text);
        emptyTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    public void setEmptyText(@StringRes int resourceId) {
        this.setEmptyText(this.getResources().getString(resourceId));
    }

    public void setEmptyText(CharSequence emptyText) {
        TextView emptyTextView = (TextView)this.getEmptyView().findViewById(R.id.state_text);
        if (emptyTextView != null) {
            emptyTextView.setText(emptyText);
        }
    }

    public void setEmptyImageDrawable(Drawable drawable) {
        ImageView image = (ImageView)this.getEmptyView().findViewById(R.id.state_image);
        if (image != null) {
            image.setVisibility(drawable != null ? 0 : 8);
            image.setImageDrawable(drawable);
        }
    }

    public void setEmptyImageResource(@DrawableRes int resourceId) {
        this.setEmptyImageDrawable(this.getResources().getDrawable(resourceId));
    }

    public void setOfflineText(@StringRes int resourceId) {
        this.setOfflineText(this.getResources().getString(resourceId));
    }

    public void setOfflineText(CharSequence offlineText) {
        TextView offlineTextView = (TextView)this.getOfflineView().findViewById(R.id.state_text);
        if (offlineTextView != null) {
            offlineTextView.setText(offlineText);
        }
    }

    public void setOfflineImageDrawable(Drawable drawable) {
        ImageView image = (ImageView)this.getOfflineView().findViewById(R.id.state_image);
        if (image != null) {
            image.setVisibility(drawable != null ? 0 : 8);
            image.setImageDrawable(drawable);
        }
    }

    public void setState(String state) {
        if (this.isTransitionsEnabled()) {
            TransitionManager.beginDelayedTransition((ViewGroup)this);
        }
        super.setState(state);
    }

    public void setOfflineImageResource(@DrawableRes int resourceId) {
        this.setOfflineImageDrawable(this.getResources().getDrawable(resourceId));
    }

    public void setTextColor(@ColorInt int color) {
        ((AppCompatImageView)this.getEmptyView().findViewById(R.id.state_image)).setSupportBackgroundTintList(ColorStateList.valueOf((int)color));
        ((AppCompatImageView)this.getOfflineView().findViewById(R.id.state_image)).setSupportBackgroundTintList(ColorStateList.valueOf((int)color));
        ((TextView)this.getEmptyView().findViewById(R.id.state_text)).setTextColor(color);
        ((TextView)this.getOfflineView().findViewById(R.id.state_text)).setTextColor(color);
    }

    public View getProgressView() {
        return this.getStateView("progress");
    }

    public void setProgressView(View progressView) {
        this.setStateView("progress", progressView);
    }

    public View getOfflineView() {
        return this.getStateView("offline");
    }

    public void setOfflineView(View offlineView) {
        this.setStateView("offline", offlineView);
    }

    public View getEmptyView() {
        return this.getStateView("empty");
    }

    public void setEmptyView(View emptyView) {
        this.setStateView("empty", emptyView);
    }

    public boolean isTransitionsEnabled() {
        return this.mTransitionsEnabled;
    }

    public void setTransitionsEnabled(boolean transitionsEnabled) {
        this.mTransitionsEnabled = transitionsEnabled;
    }

    public void setOfflineRetryOnClickListener(View.OnClickListener listener) {
        this.getOfflineView().findViewById(R.id.state_button).setOnClickListener(listener);
    }

    public void setOfflineRetryText(@StringRes int textResourceId) {
        this.setOfflineText(this.getResources().getString(textResourceId));
    }

    public void setOfflineRetryText(CharSequence text) {
        Button button = (Button)this.getOfflineView().findViewById(R.id.state_button);
        if (button != null) {
            button.setText(text);
        }
    }

    public class State
    extends StatefulLayout.State {
        public static final String PROGRESS = "progress";
        public static final String OFFLINE = "offline";
        public static final String EMPTY = "empty";
    }
}

