/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.embedmongo;

import com.mongodb.MongoClient;
import cz.jirutka.spring.embedmongo.slf4j.Slf4jLevel;
import cz.jirutka.spring.embedmongo.slf4j.Slf4jProgressListener;
import cz.jirutka.spring.embedmongo.slf4j.Slf4jStreamProcessor;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.ArtifactStoreBuilder;
import de.flapdoodle.embed.mongo.config.DownloadConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.mongo.distribution.Versions;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.GenericVersion;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import de.flapdoodle.embed.process.runtime.Network;
import de.flapdoodle.embed.process.store.Downloader;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.io.IOException;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedMongoBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedMongoBuilder.class);
    private IFeatureAwareVersion version = Version.Main.PRODUCTION;
    private Integer port;
    private String bindIp = InetAddress.getLoopbackAddress().getHostAddress();

    public MongoClient build() throws IOException {
        LOG.info("Initializing embedded MongoDB instance");
        MongodStarter runtime = MongodStarter.getInstance((IRuntimeConfig)this.buildRuntimeConfig());
        MongodExecutable mongodExe = (MongodExecutable)runtime.prepare((IExecutableProcessConfig)this.buildMongodConfig());
        LOG.info("Starting embedded MongoDB instance");
        mongodExe.start();
        return new MongoClient(this.bindIp, this.getPort());
    }

    public EmbeddedMongoBuilder version(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Version must not be null");
        }
        this.version = version;
        return this;
    }

    public EmbeddedMongoBuilder version(String version) {
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("Version must not be null or empty");
        }
        this.version = this.parseVersion(version);
        return this;
    }

    public EmbeddedMongoBuilder port(int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Port number must be between 0 and 65535");
        }
        this.port = port;
        return this;
    }

    public EmbeddedMongoBuilder bindIp(String bindIp) {
        if (bindIp == null || bindIp.isEmpty()) {
            throw new IllegalArgumentException("BindIp must not be null or empty");
        }
        this.bindIp = bindIp;
        return this;
    }

    private int getPort() {
        if (this.port == null) {
            try {
                this.port = Network.getFreeServerPort();
            }
            catch (IOException iOException) {
                LOG.error("Could not get free server port");
            }
        }
        return this.port;
    }

    private ProcessOutput buildOutputConfig() {
        Logger logger = LoggerFactory.getLogger(MongodProcess.class);
        return new ProcessOutput((IStreamProcessor)new Slf4jStreamProcessor(logger, Slf4jLevel.TRACE), (IStreamProcessor)new Slf4jStreamProcessor(logger, Slf4jLevel.WARN), (IStreamProcessor)new Slf4jStreamProcessor(logger, Slf4jLevel.INFO));
    }

    private IRuntimeConfig buildRuntimeConfig() {
        return new RuntimeConfigBuilder().defaults(Command.MongoD).processOutput(this.buildOutputConfig()).artifactStore(this.buildArtifactStore()).build();
    }

    private IArtifactStore buildArtifactStore() {
        Logger logger = LoggerFactory.getLogger(Downloader.class);
        return new ArtifactStoreBuilder().defaults(Command.MongoD).download(new DownloadConfigBuilder().defaultsForCommand(Command.MongoD).progressListener((IProgressListener)new Slf4jProgressListener(logger)).build()).build();
    }

    private IMongodConfig buildMongodConfig() throws IOException {
        return new MongodConfigBuilder().version(this.version).net(new Net(this.bindIp, this.getPort(), Network.localhostIsIPv6())).build();
    }

    private IFeatureAwareVersion parseVersion(String version) {
        String versionEnumName = version.toUpperCase().replaceAll("\\.", "_");
        if (!versionEnumName.startsWith("V")) {
            versionEnumName = "V" + versionEnumName;
        }
        try {
            return Version.valueOf((String)versionEnumName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn("Unrecognised MongoDB version '{}', this might be a new version that we don't yet know about. Attempting download anyway...", (Object)version);
            return Versions.withFeatures((IVersion)new GenericVersion(version), (Feature[])new Feature[0]);
        }
    }
}

