/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser;

import cz.jirutka.rsql.parser.Parser;
import cz.jirutka.rsql.parser.RSQLParserException;
import cz.jirutka.rsql.parser.TokenMgrError;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.NodesFactory;
import cz.jirutka.rsql.parser.ast.RSQLOperators;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class RSQLParser {
    private static final Charset ENCODING = Charset.forName("UTF-8");
    private final NodesFactory nodesFactory;

    public RSQLParser() {
        this.nodesFactory = new NodesFactory(RSQLOperators.defaultOperators());
    }

    public RSQLParser(Set<ComparisonOperator> operators) {
        if (operators == null || operators.isEmpty()) {
            throw new IllegalArgumentException("operators must not be null or empty");
        }
        this.nodesFactory = new NodesFactory(operators);
    }

    public Node parse(String query) throws RSQLParserException {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(query.getBytes(ENCODING));
        Parser parser = new Parser(is, ENCODING.name(), this.nodesFactory);
        try {
            return parser.Input();
        }
        catch (TokenMgrError | Exception ex) {
            throw new RSQLParserException(ex);
        }
    }
}

