/*
 * Decompiled with CFR 0.152.
 */
package cz.ackee.ackroutine.core;

import android.content.Context;
import android.content.SharedPreferences;
import cz.ackee.ackroutine.core.AuthStore;
import cz.ackee.ackroutine.core.OAuthCredentials;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0006\u0010\u001b\u001a\u00020\u001cR\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcz/ackee/ackroutine/core/OAuthStore;", "Lcz/ackee/ackroutine/core/AuthStore;", "Lcz/ackee/ackroutine/core/OAuthCredentials;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "sp", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "accessToken", "", "getAccessToken", "()Ljava/lang/String;", "authCredentials", "getAuthCredentials", "()Lcz/ackee/ackroutine/core/OAuthCredentials;", "expiresAt", "", "getExpiresAt", "()Ljava/lang/Long;", "refreshToken", "getRefreshToken", "clearCredentials", "", "ensureNewKeys", "saveCredentials", "credentials", "tokenExpired", "", "Companion", "coroutine-oauth_release"})
public final class OAuthStore
implements AuthStore<OAuthCredentials> {
    private final SharedPreferences sp;
    @NotNull
    public static final String DEFAULT_SP_NAME = "oauth2";
    @NotNull
    public static final String ACCESS_TOKEN_KEY_OLD = "oath2_access_token";
    @NotNull
    public static final String REFRESH_TOKEN_KEY_OLD = "oath2_refresh_token";
    @NotNull
    public static final String ACCESS_TOKEN_KEY = "oauth2_access_token";
    @NotNull
    public static final String REFRESH_TOKEN_KEY = "oauth2_refresh_token";
    @NotNull
    public static final String EXPIRES_AT_KEY = "oauth2_expires_at";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getAccessToken() {
        return this.sp.getString(ACCESS_TOKEN_KEY, null);
    }

    @Nullable
    public final String getRefreshToken() {
        return this.sp.getString(REFRESH_TOKEN_KEY, null);
    }

    @Nullable
    public final Long getExpiresAt() {
        Long l = this.sp.getLong(EXPIRES_AT_KEY, -1L);
        boolean bl = false;
        boolean bl2 = false;
        long it = ((Number)l).longValue();
        boolean bl3 = false;
        return it > (long)-1 ? l : null;
    }

    @Override
    @Nullable
    public OAuthCredentials getAuthCredentials() {
        OAuthCredentials oAuthCredentials;
        if (this.getAccessToken() != null || this.getRefreshToken() != null) {
            String string;
            String string2 = this.getAccessToken();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = this.getRefreshToken()) == null) {
                string = "";
            }
            oAuthCredentials = new OAuthCredentials(string2, string, this.getExpiresAt());
        } else {
            oAuthCredentials = null;
        }
        return oAuthCredentials;
    }

    @Override
    public void saveCredentials(@NotNull OAuthCredentials credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        SharedPreferences.Editor editor = this.sp.edit().putString(ACCESS_TOKEN_KEY, credentials.getAccessToken()).putString(REFRESH_TOKEN_KEY, credentials.getRefreshToken());
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$apply = editor;
        boolean bl3 = false;
        Long l = credentials.getExpiresIn();
        if (l != null) {
            Long l2 = l;
            boolean bl4 = false;
            boolean bl5 = false;
            long expiresIn = ((Number)l2).longValue();
            boolean bl6 = false;
            $this$apply.putLong(EXPIRES_AT_KEY, System.currentTimeMillis() + expiresIn * (long)1000);
        }
        editor.apply();
    }

    @Override
    public void clearCredentials() {
        this.sp.edit().clear().apply();
    }

    public final boolean tokenExpired() {
        return this.credentialsExpired();
    }

    private final void ensureNewKeys() {
        if (this.sp.contains(ACCESS_TOKEN_KEY_OLD)) {
            this.sp.edit().putString(ACCESS_TOKEN_KEY, this.sp.getString(ACCESS_TOKEN_KEY_OLD, null)).remove(ACCESS_TOKEN_KEY_OLD).apply();
        }
        if (this.sp.contains(REFRESH_TOKEN_KEY_OLD)) {
            this.sp.edit().putString(REFRESH_TOKEN_KEY, this.sp.getString(REFRESH_TOKEN_KEY_OLD, null)).remove(REFRESH_TOKEN_KEY_OLD).apply();
        }
    }

    public OAuthStore(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences sharedPreferences = context.getSharedPreferences(DEFAULT_SP_NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ME, Context.MODE_PRIVATE)");
        this.sp = sharedPreferences;
        this.ensureNewKeys();
    }

    public OAuthStore(@NotNull SharedPreferences sp) {
        Intrinsics.checkNotNullParameter((Object)sp, (String)"sp");
        this.sp = sp;
        this.ensureNewKeys();
    }

    @Override
    public boolean credentialsExpired() {
        return AuthStore.DefaultImpls.credentialsExpired(this);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcz/ackee/ackroutine/core/OAuthStore$Companion;", "", "()V", "ACCESS_TOKEN_KEY", "", "ACCESS_TOKEN_KEY_OLD", "DEFAULT_SP_NAME", "EXPIRES_AT_KEY", "REFRESH_TOKEN_KEY", "REFRESH_TOKEN_KEY_OLD", "coroutine-oauth_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

