/*
 * Decompiled with CFR 0.152.
 */
package cz.ackee.ackroutine.core;

import android.content.Context;
import android.content.SharedPreferences;
import cz.ackee.ackroutine.core.OAuthCredentials;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcz/ackee/ackroutine/core/OAuthStore;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "sp", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "accessToken", "", "getAccessToken", "()Ljava/lang/String;", "expiresAt", "", "getExpiresAt", "()Ljava/lang/Long;", "refreshToken", "getRefreshToken", "clearCredentials", "", "ensureNewKeys", "saveCredentials", "credentials", "Lcz/ackee/ackroutine/core/OAuthCredentials;", "tokenExpired", "", "Companion", "coroutine-oauth_release"})
public final class OAuthStore {
    private final SharedPreferences sp;
    @NotNull
    public static final String DEFAULT_SP_NAME = "oauth2";
    @NotNull
    public static final String ACCESS_TOKEN_KEY_OLD = "oath2_access_token";
    @NotNull
    public static final String REFRESH_TOKEN_KEY_OLD = "oath2_refresh_token";
    @NotNull
    public static final String ACCESS_TOKEN_KEY = "oauth2_access_token";
    @NotNull
    public static final String REFRESH_TOKEN_KEY = "oauth2_refresh_token";
    @NotNull
    public static final String EXPIRES_AT_KEY = "oauth2_expires_at";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getAccessToken() {
        return this.sp.getString(ACCESS_TOKEN_KEY, null);
    }

    @Nullable
    public final String getRefreshToken() {
        return this.sp.getString(REFRESH_TOKEN_KEY, null);
    }

    @Nullable
    public final Long getExpiresAt() {
        long l = this.sp.getLong(EXPIRES_AT_KEY, -1L);
        boolean bl = false;
        boolean bl2 = false;
        long it = l;
        boolean bl3 = false;
        return it > (long)-1 ? Long.valueOf(it) : null;
    }

    public final void saveCredentials(@NotNull OAuthCredentials credentials) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        SharedPreferences.Editor editor = this.sp.edit().putString(ACCESS_TOKEN_KEY, credentials.getAccessToken()).putString(REFRESH_TOKEN_KEY, credentials.getRefreshToken());
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$apply = editor;
        boolean bl3 = false;
        Long l = credentials.getExpiresIn();
        if (l != null) {
            Long l2 = l;
            boolean bl4 = false;
            boolean bl5 = false;
            long expiresIn = ((Number)l2).longValue();
            boolean bl6 = false;
            $this$apply.putLong(EXPIRES_AT_KEY, System.currentTimeMillis() + expiresIn * (long)1000);
        }
        editor.apply();
    }

    public final void clearCredentials() {
        this.sp.edit().clear().apply();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean tokenExpired() {
        if (this.getExpiresAt() == null) return false;
        Long l = this.getExpiresAt();
        if (l == null) {
            Intrinsics.throwNpe();
        }
        if (l >= System.currentTimeMillis()) return false;
        return true;
    }

    private final void ensureNewKeys() {
        if (this.sp.contains(ACCESS_TOKEN_KEY_OLD)) {
            this.sp.edit().putString(ACCESS_TOKEN_KEY, this.sp.getString(ACCESS_TOKEN_KEY_OLD, null)).remove(ACCESS_TOKEN_KEY_OLD).apply();
        }
        if (this.sp.contains(REFRESH_TOKEN_KEY_OLD)) {
            this.sp.edit().putString(REFRESH_TOKEN_KEY, this.sp.getString(REFRESH_TOKEN_KEY_OLD, null)).remove(REFRESH_TOKEN_KEY_OLD).apply();
        }
    }

    public OAuthStore(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sharedPreferences = context.getSharedPreferences(DEFAULT_SP_NAME, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ME, Context.MODE_PRIVATE)");
        this.sp = sharedPreferences;
        this.ensureNewKeys();
    }

    public OAuthStore(@NotNull SharedPreferences sp) {
        Intrinsics.checkParameterIsNotNull((Object)sp, (String)"sp");
        this.sp = sp;
        this.ensureNewKeys();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcz/ackee/ackroutine/core/OAuthStore$Companion;", "", "()V", "ACCESS_TOKEN_KEY", "", "ACCESS_TOKEN_KEY_OLD", "DEFAULT_SP_NAME", "EXPIRES_AT_KEY", "REFRESH_TOKEN_KEY", "REFRESH_TOKEN_KEY_OLD", "coroutine-oauth_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

