/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import android.graphics.Bitmap;
import crl.android.pdfwriter.ASCII85Encoder;
import crl.android.pdfwriter.Indentifiers;
import crl.android.pdfwriter.IndirectObject;
import crl.android.pdfwriter.PDFDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class XObjectImage {
    public static final int BITSPERCOMPONENT_8 = 8;
    public static final String DEVICE_RGB = "/DeviceRGB";
    public static boolean INTERPOLATION = false;
    public static int BITSPERCOMPONENT = 8;
    public static String COLORSPACE = "/DeviceRGB";
    public static int COMPRESSION_LEVEL = 0;
    public static String ENCODING = "ISO-8859-1";
    static int mImageCount = 0;
    private PDFDocument mDocument;
    private IndirectObject mIndirectObject;
    private int mDataSize = 0;
    private int mWidth = -1;
    private int mHeight = -1;
    private String mName = "";
    private String mId = "";
    private String mProcessedImage = "";

    public XObjectImage(PDFDocument document, Bitmap bitmap) {
        this.mDocument = document;
        this.mProcessedImage = this.processImage(this.configureBitmap(bitmap));
        this.mId = Indentifiers.generateId(this.mProcessedImage);
        this.mName = "/img" + ++mImageCount;
    }

    public void appendToDocument() {
        this.mIndirectObject = this.mDocument.newIndirectObject();
        this.mDocument.includeIndirectObject(this.mIndirectObject);
        this.mIndirectObject.addDictionaryContent(" /Type /XObject\n /Subtype /Image\n /Filter [/ASCII85Decode /FlateDecode]\n /Width " + this.mWidth + "\n" + " /Height " + this.mHeight + "\n" + " /BitsPerComponent " + Integer.toString(BITSPERCOMPONENT) + "\n" + " /Interpolate " + Boolean.toString(INTERPOLATION) + "\n" + " /ColorSpace " + DEVICE_RGB + "\n" + " /Length " + this.mProcessedImage.length() + "\n");
        this.mIndirectObject.addStreamContent(this.mProcessedImage);
    }

    private Bitmap configureBitmap(Bitmap bitmap) {
        Bitmap img = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        if (img != null) {
            this.mWidth = img.getWidth();
            this.mHeight = img.getHeight();
            this.mDataSize = this.mWidth * this.mHeight * 3;
        }
        return img;
    }

    private byte[] getBitmapData(Bitmap bitmap) {
        byte[] data = null;
        if (bitmap != null) {
            data = new byte[this.mDataSize];
            int offset = 0;
            for (int y = 0; y < this.mHeight; ++y) {
                for (int x = 0; x < this.mWidth; ++x) {
                    int intColor = bitmap.getPixel(x, y);
                    data[offset++] = (byte)(intColor >> 16 & 0xFF);
                    data[offset++] = (byte)(intColor >> 8 & 0xFF);
                    data[offset++] = (byte)(intColor >> 0 & 0xFF);
                }
            }
        }
        return data;
    }

    private boolean deflateImageData(ByteArrayOutputStream baos, byte[] data) {
        if (data != null) {
            Deflater deflater = new Deflater(COMPRESSION_LEVEL);
            DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, deflater);
            try {
                dos.write(data);
                dos.close();
                deflater.end();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private String encodeImageData(ByteArrayOutputStream baos) {
        ByteArrayOutputStream sob = new ByteArrayOutputStream();
        ASCII85Encoder enc85 = new ASCII85Encoder(sob);
        try {
            int i = 0;
            for (byte b : baos.toByteArray()) {
                enc85.write(b);
                if (i++ != 255) continue;
                sob.write(10);
                i = 0;
            }
            return sob.toString(ENCODING);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private String processImage(Bitmap bitmap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.deflateImageData(baos, this.getBitmapData(bitmap))) {
            return this.encodeImageData(baos);
        }
        return null;
    }

    public String asXObjectReference() {
        return this.mName + " " + this.mIndirectObject.getIndirectReference();
    }

    public String getName() {
        return this.mName;
    }

    public String getId() {
        return this.mId;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }
}

