/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.IndirectObject;
import crl.android.pdfwriter.PDFDocument;
import crl.android.pdfwriter.XObjectImage;
import java.util.ArrayList;

public class Page {
    private PDFDocument mDocument;
    private IndirectObject mIndirectObject;
    private ArrayList<IndirectObject> mPageFonts;
    private ArrayList<XObjectImage> mXObjects;
    private IndirectObject mPageContents;

    public Page(PDFDocument document) {
        this.mDocument = document;
        this.mIndirectObject = this.mDocument.newIndirectObject();
        this.mPageFonts = new ArrayList();
        this.mXObjects = new ArrayList();
        this.setFont("Type1", "Times-Roman", "WinAnsiEncoding");
        this.mPageContents = this.mDocument.newIndirectObject();
        this.mDocument.includeIndirectObject(this.mPageContents);
    }

    public IndirectObject getIndirectObject() {
        return this.mIndirectObject;
    }

    private String getFontReferences() {
        String result = "";
        if (!this.mPageFonts.isEmpty()) {
            result = "    /Font <<\n";
            int x = 0;
            for (IndirectObject lFont : this.mPageFonts) {
                result = result + "      /F" + Integer.toString(++x) + " " + lFont.getIndirectReference() + "\n";
            }
            result = result + "    >>\n";
        }
        return result;
    }

    private String getXObjectReferences() {
        String result = "";
        if (!this.mXObjects.isEmpty()) {
            result = "    /XObject <<\n";
            for (XObjectImage xObj : this.mXObjects) {
                result = result + "      " + xObj.asXObjectReference() + "\n";
            }
            result = result + "    >>\n";
        }
        return result;
    }

    public void render(String pagesIndirectReference) {
        this.mIndirectObject.setDictionaryContent("  /Type /Page\n  /Parent " + pagesIndirectReference + "\n" + "  /Resources <<\n" + this.getFontReferences() + this.getXObjectReferences() + "  >>\n" + "  /Contents " + this.mPageContents.getIndirectReference() + "\n");
    }

    public void setFont(String subType, String baseFont) {
        IndirectObject lFont = this.mDocument.newIndirectObject();
        this.mDocument.includeIndirectObject(lFont);
        lFont.setDictionaryContent("  /Type /Font\n  /Subtype /" + subType + "\n  /BaseFont /" + baseFont + "\n");
        this.mPageFonts.add(lFont);
    }

    public void setFont(String subType, String baseFont, String encoding) {
        IndirectObject lFont = this.mDocument.newIndirectObject();
        this.mDocument.includeIndirectObject(lFont);
        lFont.setDictionaryContent("  /Type /Font\n  /Subtype /" + subType + "\n  /BaseFont /" + baseFont + "\n  /Encoding /" + encoding + "\n");
        this.mPageFonts.add(lFont);
    }

    private void addContent(String content) {
        this.mPageContents.addStreamContent(content);
        String streamContent = this.mPageContents.getStreamContent();
        this.mPageContents.setDictionaryContent("  /Length " + Integer.toString(streamContent.length()) + "\n");
        this.mPageContents.setStreamContent(streamContent);
    }

    public void addRawContent(String rawContent) {
        this.addContent(rawContent);
    }

    public void addText(int leftPosition, int topPositionFromBottom, int fontSize, String text) {
        this.addText(leftPosition, topPositionFromBottom, fontSize, text, "1 0 0 1");
    }

    public void addText(int leftPosition, int topPositionFromBottom, int fontSize, String text, String transformation) {
        this.addContent("BT\n" + transformation + " " + Integer.toString(leftPosition) + " " + Integer.toString(topPositionFromBottom) + " Tm\n" + "/F" + Integer.toString(this.mPageFonts.size()) + " " + Integer.toString(fontSize) + " Tf\n" + "(" + text + ") Tj\n" + "ET\n");
    }

    public void addTextAsHex(int leftPosition, int topPositionFromBottom, int fontSize, String hex) {
        this.addTextAsHex(leftPosition, topPositionFromBottom, fontSize, hex, "1 0 0 1");
    }

    public void addTextAsHex(int leftPosition, int topPositionFromBottom, int fontSize, String hex, String transformation) {
        this.addContent("BT\n" + transformation + " " + Integer.toString(leftPosition) + " " + Integer.toString(topPositionFromBottom) + " Tm\n" + "/F" + Integer.toString(this.mPageFonts.size()) + " " + Integer.toString(fontSize) + " Tf\n" + "<" + hex + "> Tj\n" + "ET\n");
    }

    public void addLine(int fromLeft, int fromBottom, int toLeft, int toBottom) {
        this.addContent(Integer.toString(fromLeft) + " " + Integer.toString(fromBottom) + " m\n" + Integer.toString(toLeft) + " " + Integer.toString(toBottom) + " l\nS\n");
    }

    public void addRectangle(int fromLeft, int fromBottom, int toLeft, int toBottom) {
        this.addContent(Integer.toString(fromLeft) + " " + Integer.toString(fromBottom) + " " + Integer.toString(toLeft) + " " + Integer.toString(toBottom) + " re\nS\n");
    }

    private String ensureXObjectImage(XObjectImage xObject) {
        for (XObjectImage x : this.mXObjects) {
            if (!x.getId().equals(xObject.getId())) continue;
            return x.getName();
        }
        this.mXObjects.add(xObject);
        xObject.appendToDocument();
        return xObject.getName();
    }

    public void addImage(int fromLeft, int fromBottom, int width, int height, XObjectImage xImage, String transformation) {
        String name = this.ensureXObjectImage(xImage);
        String translate = "1 0 0 1 " + fromLeft + " " + fromBottom;
        String scale = "" + width + " 0 0 " + height + " 0 0";
        String rotate = transformation + " 0 0";
        this.addContent("q\n" + translate + " cm\n" + rotate + " cm\n" + scale + " cm\n" + name + " Do\n" + "Q\n");
    }
}

