/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import android.graphics.Bitmap;
import crl.android.pdfwriter.IndirectObject;
import crl.android.pdfwriter.PDFDocument;
import crl.android.pdfwriter.Page;
import crl.android.pdfwriter.Pages;
import crl.android.pdfwriter.XObjectImage;
import java.io.IOException;
import java.io.OutputStream;

public class PDFWriter {
    private PDFDocument mDocument;
    private IndirectObject mCatalog;
    private Pages mPages;
    private Page mCurrentPage;

    public PDFWriter() {
        this.newDocument(595, 842);
    }

    public PDFWriter(int pageWidth, int pageHeight) {
        this.newDocument(pageWidth, pageHeight);
    }

    private void newDocument(int pageWidth, int pageHeight) {
        this.mDocument = new PDFDocument();
        this.mCatalog = this.mDocument.newIndirectObject();
        this.mDocument.includeIndirectObject(this.mCatalog);
        this.mPages = new Pages(this.mDocument, pageWidth, pageHeight);
        this.mDocument.includeIndirectObject(this.mPages.getIndirectObject());
        this.renderCatalog();
        this.newPage();
    }

    private void renderCatalog() {
        this.mCatalog.setDictionaryContent("  /Type /Catalog\n  /Pages " + this.mPages.getIndirectObject().getIndirectReference() + "\n");
    }

    public void newPage() {
        this.mCurrentPage = this.mPages.newPage();
        this.mDocument.includeIndirectObject(this.mCurrentPage.getIndirectObject());
        this.mPages.render();
    }

    public void setCurrentPage(int pageNumber) {
        this.mCurrentPage = this.mPages.getPageAt(pageNumber);
    }

    public int getPageCount() {
        return this.mPages.getCount();
    }

    public void setFont(String subType, String baseFont) {
        this.mCurrentPage.setFont(subType, baseFont);
    }

    public void setFont(String subType, String baseFont, String encoding) {
        this.mCurrentPage.setFont(subType, baseFont, encoding);
    }

    public void addRawContent(String rawContent) {
        this.mCurrentPage.addRawContent(rawContent);
    }

    public void addText(int leftPosition, int topPositionFromBottom, int fontSize, String text) {
        this.addText(leftPosition, topPositionFromBottom, fontSize, text, "1 0 0 1");
    }

    public void addText(int leftPosition, int topPositionFromBottom, int fontSize, String text, String transformation) {
        this.mCurrentPage.addText(leftPosition, topPositionFromBottom, fontSize, text, transformation);
    }

    public void addTextAsHex(int leftPosition, int topPositionFromBottom, int fontSize, String hex) {
        this.addTextAsHex(leftPosition, topPositionFromBottom, fontSize, hex, "1 0 0 1");
    }

    public void addTextAsHex(int leftPosition, int topPositionFromBottom, int fontSize, String hex, String transformation) {
        this.mCurrentPage.addTextAsHex(leftPosition, topPositionFromBottom, fontSize, hex, transformation);
    }

    public void addLine(int fromLeft, int fromBottom, int toLeft, int toBottom) {
        this.mCurrentPage.addLine(fromLeft, fromBottom, toLeft, toBottom);
    }

    public void addRectangle(int fromLeft, int fromBottom, int toLeft, int toBottom) {
        this.mCurrentPage.addRectangle(fromLeft, fromBottom, toLeft, toBottom);
    }

    public void addImage(int fromLeft, int fromBottom, Bitmap bitmap) {
        this.addImage(fromLeft, fromBottom, bitmap, "1 0 0 1");
    }

    public void addImage(int fromLeft, int fromBottom, Bitmap bitmap, String transformation) {
        XObjectImage xImage = new XObjectImage(this.mDocument, bitmap);
        this.mCurrentPage.addImage(fromLeft, fromBottom, xImage.getWidth(), xImage.getHeight(), xImage, transformation);
    }

    public void addImage(int fromLeft, int fromBottom, int toLeft, int toBottom, Bitmap bitmap) {
        this.addImage(fromLeft, fromBottom, toLeft, toBottom, bitmap, "1 0 0 1");
    }

    public void addImage(int fromLeft, int fromBottom, int toLeft, int toBottom, Bitmap bitmap, String transformation) {
        this.mCurrentPage.addImage(fromLeft, fromBottom, toLeft, toBottom, new XObjectImage(this.mDocument, bitmap), transformation);
    }

    public void addImageKeepRatio(int fromLeft, int fromBottom, int width, int height, Bitmap bitmap) {
        this.addImageKeepRatio(fromLeft, fromBottom, width, height, bitmap, "1 0 0 1");
    }

    public void addImageKeepRatio(int fromLeft, int fromBottom, int width, int height, Bitmap bitmap, String transformation) {
        float boxRatio;
        XObjectImage xImage = new XObjectImage(this.mDocument, bitmap);
        float imgRatio = (float)xImage.getWidth() / (float)xImage.getHeight();
        float ratio = imgRatio < (boxRatio = (float)width / (float)height) ? (float)width / (float)xImage.getWidth() : (float)height / (float)xImage.getHeight();
        width = (int)((float)xImage.getWidth() * ratio);
        height = (int)((float)xImage.getHeight() * ratio);
        this.mCurrentPage.addImage(fromLeft, fromBottom, width, height, xImage, transformation);
    }

    public String asString() {
        this.mPages.render();
        return this.mDocument.toPDFString();
    }

    void setId(String id) {
        this.mDocument.setId(id);
    }

    public void writeTo(OutputStream stream) throws IOException {
        this.mPages.render();
        this.mDocument.writeTo(stream);
    }
}

