/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.Base;
import crl.android.pdfwriter.Body;
import crl.android.pdfwriter.CrossReferenceTable;
import crl.android.pdfwriter.Header;
import crl.android.pdfwriter.Indentifiers;
import crl.android.pdfwriter.IndirectObject;
import crl.android.pdfwriter.Trailer;
import java.io.IOException;
import java.io.OutputStream;

public class PDFDocument
extends Base {
    private Header mHeader = new Header();
    private Body mBody = new Body();
    private CrossReferenceTable mCRT;
    private Trailer mTrailer;

    public PDFDocument() {
        this.mBody.setByteOffsetStart(this.mHeader.getPDFStringSize());
        this.mBody.setObjectNumberStart(0);
        this.mCRT = new CrossReferenceTable();
        this.mTrailer = new Trailer();
        this.setId(Indentifiers.generateId());
    }

    public IndirectObject newIndirectObject() {
        return this.mBody.getNewIndirectObject();
    }

    public IndirectObject newRawObject(String content) {
        IndirectObject iobj = this.mBody.getNewIndirectObject();
        iobj.setContent(content);
        return iobj;
    }

    public IndirectObject newDictionaryObject(String dictionaryContent) {
        IndirectObject iobj = this.mBody.getNewIndirectObject();
        iobj.setDictionaryContent(dictionaryContent);
        return iobj;
    }

    public IndirectObject newStreamObject(String streamContent) {
        IndirectObject iobj = this.mBody.getNewIndirectObject();
        iobj.setDictionaryContent("  /Length " + Integer.toString(streamContent.length()) + "\n");
        iobj.setStreamContent(streamContent);
        return iobj;
    }

    public void includeIndirectObject(IndirectObject iobj) {
        this.mBody.includeIndirectObject(iobj);
    }

    void setId(String id) {
        this.mTrailer.setId(id);
    }

    @Override
    public String toPDFString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mHeader.toPDFString());
        sb.append(this.mBody.toPDFString());
        this.mCRT.setObjectNumberStart(this.mBody.getObjectNumberStart());
        int x = 0;
        while (x < this.mBody.getObjectsCount()) {
            IndirectObject iobj;
            if ((iobj = this.mBody.getObjectByNumberID(++x)) == null) continue;
            this.mCRT.addObjectXRefInfo(iobj.getByteOffset(), iobj.getGeneration(), iobj.getInUse());
        }
        this.mTrailer.setObjectsCount(this.mBody.getObjectsCount());
        this.mTrailer.setCrossReferenceTableByteOffset(sb.length());
        return sb.toString() + this.mCRT.toPDFString() + this.mTrailer.toPDFString();
    }

    public void writeTo(OutputStream stream) throws IOException {
        int offset = this.mHeader.writeTo(stream);
        offset += this.mBody.writeTo(stream);
        this.mCRT.setObjectNumberStart(this.mBody.getObjectNumberStart());
        int x = 0;
        while (x < this.mBody.getObjectsCount()) {
            IndirectObject iobj;
            if ((iobj = this.mBody.getObjectByNumberID(++x)) == null) continue;
            this.mCRT.addObjectXRefInfo(iobj.getByteOffset(), iobj.getGeneration(), iobj.getInUse());
        }
        this.mCRT.writeTo(stream);
        this.mTrailer.setObjectsCount(this.mBody.getObjectsCount());
        this.mTrailer.setCrossReferenceTableByteOffset(offset);
        this.mTrailer.writeTo(stream);
    }

    @Override
    public void clear() {
        this.mHeader.clear();
        this.mBody.clear();
        this.mCRT.clear();
        this.mTrailer.clear();
    }
}

