/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.Base;
import crl.android.pdfwriter.Dictionary;
import crl.android.pdfwriter.EnclosedContent;
import crl.android.pdfwriter.IndirectIdentifier;
import crl.android.pdfwriter.Stream;
import java.io.IOException;
import java.io.OutputStream;

public class IndirectObject
extends Base {
    private EnclosedContent mContent;
    private Dictionary mDictionaryContent;
    private Stream mStreamContent;
    private IndirectIdentifier mID;
    private int mByteOffset;
    private boolean mInUse;

    public IndirectObject() {
        this.clear();
    }

    public void setNumberID(int Value) {
        this.mID.setNumber(Value);
    }

    public int getNumberID() {
        return this.mID.getNumber();
    }

    public void setGeneration(int Value) {
        this.mID.setGeneration(Value);
    }

    public int getGeneration() {
        return this.mID.getGeneration();
    }

    public String getIndirectReference() {
        return this.mID.toPDFString() + " R";
    }

    public void setByteOffset(int Value) {
        this.mByteOffset = Value;
    }

    public int getByteOffset() {
        return this.mByteOffset;
    }

    public void setInUse(boolean Value) {
        this.mInUse = Value;
    }

    public boolean getInUse() {
        return this.mInUse;
    }

    public void addContent(String Value) {
        this.mContent.addContent(Value);
    }

    public void setContent(String Value) {
        this.mContent.setContent(Value);
    }

    public String getContent() {
        return this.mContent.getContent();
    }

    public void addDictionaryContent(String Value) {
        this.mDictionaryContent.addContent(Value);
    }

    public void setDictionaryContent(String Value) {
        this.mDictionaryContent.setContent(Value);
    }

    public String getDictionaryContent() {
        return this.mDictionaryContent.getContent();
    }

    public void addStreamContent(String Value) {
        this.mStreamContent.addContent(Value);
    }

    public void setStreamContent(String Value) {
        this.mStreamContent.setContent(Value);
    }

    public String getStreamContent() {
        return this.mStreamContent.getContent();
    }

    protected String render() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mID.toPDFString());
        sb.append(" ");
        if (this.mDictionaryContent.hasContent()) {
            this.mContent.setContent(this.mDictionaryContent.toPDFString());
            if (this.mStreamContent.hasContent()) {
                this.mContent.addContent(this.mStreamContent.toPDFString());
            }
        }
        sb.append(this.mContent.toPDFString());
        return sb.toString();
    }

    @Override
    public void clear() {
        this.mID = new IndirectIdentifier();
        this.mByteOffset = 0;
        this.mInUse = false;
        this.mContent = new EnclosedContent("obj\n", "endobj\n");
        this.mDictionaryContent = new Dictionary();
        this.mStreamContent = new Stream();
    }

    @Override
    public String toPDFString() {
        return this.render();
    }

    public int writeTo(OutputStream stream) throws IOException {
        if (this.mDictionaryContent.hasContent()) {
            this.mContent.setContent(this.mDictionaryContent.toPDFString());
            if (this.mStreamContent.hasContent()) {
                this.mContent.addContent(this.mStreamContent.toPDFString());
            }
        }
        int offset = this.mID.writeTo(stream);
        stream.write(32);
        return ++offset + this.mContent.writeTo(stream);
    }
}

