/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class Indentifiers {
    private static char[] HexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static final String calculateMd5(String s) {
        StringBuffer MD5Str = new StringBuffer();
        try {
            MessageDigest MD5digester = MessageDigest.getInstance("MD5");
            MD5digester.update(s.getBytes());
            byte[] binMD5 = MD5digester.digest();
            int len = binMD5.length;
            for (int i = 0; i < len; ++i) {
                MD5Str.append(HexTable[binMD5[i] >> 4 & 0xF]);
                MD5Str.append(HexTable[binMD5[i] >> 0 & 0xF]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return MD5Str.toString();
    }

    private static String encodeDate(Date date) {
        Calendar c = GregorianCalendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(10);
        int minute = c.get(12);
        int m = c.get(16) / 60000;
        int dts_h = m / 60;
        int dts_m = m % 60;
        String sign = m > 0 ? "+" : "-";
        return String.format("(D:%40d%20d%20d%20d%20d%s%20d'%20d')", year, month, day, hour, minute, sign, dts_h, dts_m);
    }

    public static String generateId() {
        return Indentifiers.calculateMd5(Indentifiers.encodeDate(new Date()));
    }

    public static String generateId(String data) {
        return Indentifiers.calculateMd5(data);
    }
}

