/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.Base;
import crl.android.pdfwriter.StandardCharsets;
import java.io.IOException;
import java.io.OutputStream;

public class Header
extends Base {
    private String mVersion;
    private String mRenderedHeader;

    public Header() {
        this.clear();
    }

    public void setVersion(int Major, int Minor) {
        this.mVersion = Integer.toString(Major) + "." + Integer.toString(Minor);
        this.render();
    }

    public int getPDFStringSize() {
        return this.mRenderedHeader.length();
    }

    private void render() {
        this.mRenderedHeader = "%PDF-" + this.mVersion + "\n%\u00a9\u00bb\u00aa\u00b5\n";
    }

    @Override
    public String toPDFString() {
        return this.mRenderedHeader;
    }

    @Override
    public void clear() {
        this.setVersion(1, 4);
    }

    public int writeTo(OutputStream stream) throws IOException {
        byte[] bytes = this.mRenderedHeader.getBytes(StandardCharsets.US_ASCII);
        stream.write(bytes);
        return bytes.length;
    }
}

