/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.Base;
import crl.android.pdfwriter.StandardCharsets;
import java.io.IOException;
import java.io.OutputStream;

public class EnclosedContent
extends Base {
    private final String mBegin;
    private final String mEnd;
    protected StringBuilder mContent;

    public EnclosedContent(String begin, String end) {
        this.mBegin = begin;
        this.mEnd = end;
        this.clear();
    }

    public boolean hasContent() {
        return this.mContent.length() > 0;
    }

    public void setContent(String Value) {
        this.clear();
        this.mContent.append(Value);
    }

    public String getContent() {
        return this.mContent.toString();
    }

    public void addContent(String Value) {
        this.mContent.append(Value);
    }

    public void addNewLine() {
        this.mContent.append("\n");
    }

    public void addSpace() {
        this.mContent.append(" ");
    }

    @Override
    public void clear() {
        this.mContent = new StringBuilder();
    }

    @Override
    public String toPDFString() {
        return this.mBegin + this.mContent.toString() + this.mEnd;
    }

    public int writeTo(OutputStream stream) throws IOException {
        byte[] bytes = this.toPDFString().getBytes(StandardCharsets.US_ASCII);
        stream.write(bytes);
        return bytes.length;
    }
}

