/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.IndirectObject;
import crl.android.pdfwriter.List;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class Body
extends List {
    private int mByteOffsetStart;
    private int mObjectNumberStart;
    private int mGeneratedObjectsCount;
    private ArrayList<IndirectObject> mObjectsList;

    public Body() {
        this.clear();
    }

    public int getObjectNumberStart() {
        return this.mObjectNumberStart;
    }

    public void setObjectNumberStart(int Value) {
        this.mObjectNumberStart = Value;
    }

    public int getByteOffsetStart() {
        return this.mByteOffsetStart;
    }

    public void setByteOffsetStart(int Value) {
        this.mByteOffsetStart = Value;
    }

    public int getObjectsCount() {
        return this.mObjectsList.size();
    }

    private int getNextAvailableObjectNumber() {
        return ++this.mGeneratedObjectsCount + this.mObjectNumberStart;
    }

    public IndirectObject getNewIndirectObject() {
        return this.getNewIndirectObject(this.getNextAvailableObjectNumber(), 0, true);
    }

    public IndirectObject getNewIndirectObject(int Number, int Generation, boolean InUse) {
        IndirectObject iobj = new IndirectObject();
        iobj.setNumberID(Number);
        iobj.setGeneration(Generation);
        iobj.setInUse(InUse);
        return iobj;
    }

    public IndirectObject getObjectByNumberID(int Number) {
        for (IndirectObject iobj : this.mObjectsList) {
            if (iobj.getNumberID() != Number) continue;
            return iobj;
        }
        return null;
    }

    public void includeIndirectObject(IndirectObject iobj) {
        this.mObjectsList.add(iobj);
    }

    private String render() {
        int offset = this.mByteOffsetStart;
        for (int x = 1; x <= this.mObjectsList.size(); ++x) {
            IndirectObject iobj = this.getObjectByNumberID(x);
            String s = "";
            if (iobj != null) {
                s = iobj.toPDFString() + "\n";
            }
            this.mList.add(s);
            iobj.setByteOffset(offset);
            offset += s.length();
        }
        return this.renderList();
    }

    @Override
    public String toPDFString() {
        return this.render();
    }

    public int writeTo(OutputStream stream) throws IOException {
        int offset = this.mByteOffsetStart;
        for (int x = 1; x <= this.mObjectsList.size(); ++x) {
            IndirectObject iobj = this.getObjectByNumberID(x);
            if (iobj == null) continue;
            iobj.setByteOffset(offset);
            offset += iobj.writeTo(stream) + 1;
            stream.write(10);
        }
        return offset - this.mByteOffsetStart;
    }

    @Override
    public void clear() {
        super.clear();
        this.mByteOffsetStart = 0;
        this.mObjectNumberStart = 0;
        this.mGeneratedObjectsCount = 0;
        this.mObjectsList = new ArrayList();
    }
}

