/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.Base;
import crl.android.pdfwriter.Dictionary;

public class Trailer
extends Base {
    private int mXRefByteOffset;
    private int mObjectsCount;
    private String mId;
    private Dictionary mTrailerDictionary;

    public Trailer() {
        this.clear();
    }

    public void setId(String Value) {
        this.mId = Value;
    }

    public void setCrossReferenceTableByteOffset(int Value) {
        this.mXRefByteOffset = Value;
    }

    public void setObjectsCount(int Value) {
        this.mObjectsCount = Value;
    }

    private void renderDictionary() {
        this.mTrailerDictionary.setContent("  /Size " + Integer.toString(this.mObjectsCount));
        this.mTrailerDictionary.addNewLine();
        this.mTrailerDictionary.addContent("  /Root 1 0 R");
        this.mTrailerDictionary.addNewLine();
        this.mTrailerDictionary.addContent("  /ID [<" + this.mId + "> <" + this.mId + ">]");
        this.mTrailerDictionary.addNewLine();
    }

    private String render() {
        this.renderDictionary();
        StringBuilder sb = new StringBuilder();
        sb.append("trailer");
        sb.append("\n");
        sb.append(this.mTrailerDictionary.toPDFString());
        sb.append("startxref");
        sb.append("\n");
        sb.append(this.mXRefByteOffset);
        sb.append("\n");
        sb.append("%%EOF");
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String toPDFString() {
        return this.render();
    }

    @Override
    public void clear() {
        this.mXRefByteOffset = 0;
        this.mTrailerDictionary = new Dictionary();
    }
}

