/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.Base;

public class EnclosedContent
extends Base {
    private String mBegin;
    private String mEnd;
    protected StringBuilder mContent;

    public EnclosedContent() {
        this.clear();
    }

    public void setBeginKeyword(String Value, boolean NewLineBefore, boolean NewLineAfter) {
        this.mBegin = NewLineBefore ? "\n" + Value : Value;
        if (NewLineAfter) {
            this.mBegin = this.mBegin + "\n";
        }
    }

    public void setEndKeyword(String Value, boolean NewLineBefore, boolean NewLineAfter) {
        this.mEnd = NewLineBefore ? "\n" + Value : Value;
        if (NewLineAfter) {
            this.mEnd = this.mEnd + "\n";
        }
    }

    public boolean hasContent() {
        return this.mContent.length() > 0;
    }

    public void setContent(String Value) {
        this.clear();
        this.mContent.append(Value);
    }

    public String getContent() {
        return this.mContent.toString();
    }

    public void addContent(String Value) {
        this.mContent.append(Value);
    }

    public void addNewLine() {
        this.mContent.append("\n");
    }

    public void addSpace() {
        this.mContent.append(" ");
    }

    @Override
    public void clear() {
        this.mContent = new StringBuilder();
    }

    @Override
    public String toPDFString() {
        return this.mBegin + this.mContent.toString() + this.mEnd;
    }
}

