/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.List;

public class CrossReferenceTable
extends List {
    private int mObjectNumberStart;

    public CrossReferenceTable() {
        this.clear();
    }

    public void setObjectNumberStart(int Value) {
        this.mObjectNumberStart = Value;
    }

    public int getObjectNumberStart() {
        return this.mObjectNumberStart;
    }

    private String getObjectsXRefInfo() {
        return this.renderList();
    }

    public void addObjectXRefInfo(int ByteOffset, int Generation, boolean InUse) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%010d", ByteOffset));
        sb.append(" ");
        sb.append(String.format("%05d", Generation));
        if (InUse) {
            sb.append(" n ");
        } else {
            sb.append(" f ");
        }
        sb.append("\r\n");
        this.mList.add(sb.toString());
    }

    private String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("xref");
        sb.append("\r\n");
        sb.append(this.mObjectNumberStart);
        sb.append(" ");
        sb.append(this.mList.size());
        sb.append("\r\n");
        sb.append(this.getObjectsXRefInfo());
        return sb.toString();
    }

    @Override
    public String toPDFString() {
        return this.render();
    }

    @Override
    public void clear() {
        super.clear();
        this.addObjectXRefInfo(0, 65536, false);
        this.mObjectNumberStart = 0;
    }
}

