/*
 * Decompiled with CFR 0.152.
 */
package cprice404.plugins.workflow.steps;

import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.File;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class AddToClasspathStep
extends AbstractStepImpl {
    private final String path;

    @DataBoundConstructor
    public AddToClasspathStep(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Void> {
        @Inject
        private transient AddToClasspathStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient CpsFlowExecution cpsFlowExecution;
        private static final long serialVersionUID = 1L;

        protected Void run() throws Exception {
            GroovyShell shell = this.cpsFlowExecution.getShell();
            shell.getClassLoader().addURL(new File(this.step.getPath()).toURI().toURL());
            this.listener.getLogger().println(this.step.getPath());
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "addToClasspath";
        }

        public String getDisplayName() {
            return "Add file path to Groovy classPath";
        }
    }
}

