/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.databinding.bundle;

import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.iterator.IteratorFactory;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.struts.util.MessageResources;
import weblogic.utils.UnsyncStringBuffer;

public class BundleContext {
    public static final String KEY = "_netui_pageContext_bundleContext";
    public static final String DEFAULT_STRUTS_BUNDLE_NAME = "default";
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$tags$databinding$bundle$BundleContext == null ? (class$com$bea$wlw$netui$tags$databinding$bundle$BundleContext = BundleContext.class$("com.bea.wlw.netui.tags.databinding.bundle.BundleContext")) : class$com$bea$wlw$netui$tags$databinding$bundle$BundleContext));
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$tags$databinding$bundle$BundleContext == null ? (class$com$bea$wlw$netui$tags$databinding$bundle$BundleContext = BundleContext.class$("com.bea.wlw.netui.tags.databinding.bundle.BundleContext")) : class$com$bea$wlw$netui$tags$databinding$bundle$BundleContext));
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private Map bundles = null;
    static /* synthetic */ Class class$com$bea$wlw$netui$tags$databinding$bundle$BundleContext;

    BundleContext() {
    }

    public void addBundle(String name, String bundleName) {
        this.addBundle(name, bundleName, null);
    }

    public void addBundle(String name, String bundleName, Locale localeOverride) {
        if (this.bundles == null) {
            this.bundles = new HashMap();
        }
        if (this.bundles.containsKey(name)) {
            logger.info((Object)("The bundle map already contains a key \"" + name + "\" overwriting the previous value."));
        }
        NetUIBundleNode node = new NetUIBundleNode(bundleName, localeOverride != null ? localeOverride : DEFAULT_LOCALE);
        this.bundles.put(name, node);
    }

    public Iterator getBundleNames() {
        if (this.bundles == null) {
            return IteratorFactory.EMPTY_ITERATOR;
        }
        return this.bundles.keySet().iterator();
    }

    public boolean containsBundle(String name) {
        if (this.bundles == null) {
            return false;
        }
        return this.bundles.containsKey(name);
    }

    public BundleNode getBundle(String name) {
        if (this.bundles == null) {
            return null;
        }
        BundleNode bn = (BundleNode)this.bundles.get(name);
        if (bn == null) {
            return null;
        }
        bn.init();
        return bn;
    }

    public String toString() {
        UnsyncStringBuffer buf = new UnsyncStringBuffer(256);
        Iterator iterator = this.getBundleNames();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                Object key = iterator.next();
                buf.append("bundle name: " + key + " bundle path: " + ((BundleNode)this.bundles.get(key)).bundleName + "\n");
            }
        } else {
            buf.append("No registered bundles.\n");
        }
        return buf.toString();
    }

    public static BundleNode createBundleNode(String name, Object messageResource, Locale locale) {
        if (messageResource instanceof MessageResources) {
            return new StrutsBundleNode(name, locale, (MessageResources)messageResource);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class StrutsBundleNode
    extends BundleNode {
        private String name;
        private MessageResources messageResource;

        StrutsBundleNode(String name, Locale locale, MessageResources messageResource) {
            super(null, locale);
            this.name = name;
            this.messageResource = messageResource;
        }

        public boolean containsKey(String key) {
            return this.messageResource.getMessage(this.locale, key) != null;
        }

        public String getString(String key) {
            return this.messageResource.getMessage(this.locale, key);
        }

        public Enumeration getKeys() {
            throw new UnsupportedOperationException("The getKeys() method is not supported on a Struts bundle.");
        }
    }

    public static class NetUIBundleNode
    extends BundleNode {
        private ResourceBundle bundle;

        NetUIBundleNode(String bundleName, Locale locale) {
            super(bundleName, locale);
        }

        public void init() {
            if (this.bundle == null) {
                this.bundle = ResourceBundle.getBundle(this.bundleName, this.locale);
            }
        }

        public boolean containsKey(String key) {
            return this.bundle.getString(key) != null;
        }

        public String getString(String key) {
            return this.bundle.getString(key);
        }

        public Enumeration getKeys() {
            return this.bundle.getKeys();
        }
    }

    public static abstract class BundleNode {
        protected String bundleName;
        protected Locale locale;

        BundleNode(String bundleName, Locale locale) {
            this.bundleName = bundleName;
            this.locale = locale;
        }

        public void init() {
        }

        public abstract boolean containsKey(String var1);

        public abstract String getString(String var1);

        public abstract Enumeration getKeys();
    }
}

