/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script.el;

import com.bea.wlw.netui.script.el.ExpressionTerm;
import com.bea.wlw.netui.script.el.LiteralTerm;
import com.bea.wlw.netui.script.el.Term;
import com.bea.wlw.netui.script.el.VariableResolver;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.ArrayList;
import java.util.List;

public class ParsedExpression {
    private static Logger _logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$script$el$ParsedExpression == null ? (class$com$bea$wlw$netui$script$el$ParsedExpression = ParsedExpression.class$("com.bea.wlw.netui.script.el.ParsedExpression")) : class$com$bea$wlw$netui$script$el$ParsedExpression));
    private static final boolean debugEnabled = _logger.isDebugEnabled();
    private static final String EMPTY_STRING = "";
    private List terms = new ArrayList();
    private boolean isExpression = false;
    private boolean containsExpression = false;
    private ExpressionTerm atomicExpression = null;
    private Term[] termArray = null;
    private String exprStr;
    static /* synthetic */ Class class$com$bea$wlw$netui$script$el$ParsedExpression;

    public void seal() {
        this.termArray = new Term[this.terms.size()];
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.terms.size()) {
            String lit;
            Term t = (Term)this.terms.get(i);
            t.seal();
            if (t instanceof ExpressionTerm) {
                if (this.terms.size() == 1) {
                    this.atomicExpression = (ExpressionTerm)this.terms.get(0);
                    this.isExpression = true;
                }
                this.containsExpression = true;
            } else if (t instanceof LiteralTerm && (lit = t.getExpressionString()) != null && lit.indexOf("{") > -1) {
                this.containsExpression = true;
            }
            this.termArray[i] = (Term)this.terms.get(i);
            buf.append(t.getExpressionString());
            ++i;
        }
        this.exprStr = buf.toString();
    }

    public boolean isExpression() {
        return this.isExpression;
    }

    public boolean containsExpression() {
        return this.containsExpression;
    }

    public void addTerm(Term term) {
        this.terms.add(term);
    }

    public int getTokenCount() {
        return this.terms.size();
    }

    public Term getTerm(int i) {
        return this.termArray[i];
    }

    public ExpressionTerm getAtomicExpressionTerm() {
        return this.atomicExpression;
    }

    public Object evaluate(VariableResolver vr) {
        if (debugEnabled) {
            _logger.debug((Object)("evaluate expression: " + this.exprStr));
        }
        if (this.isExpression) {
            if (debugEnabled) {
                _logger.debug((Object)"atoimc expression");
            }
            return this.atomicExpression.evaluate(vr);
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.terms.size()) {
            Object result;
            if (debugEnabled) {
                _logger.debug((Object)("term[" + i + "]: " + this.termArray[i].getClass().getName() + " expression string: " + this.termArray[i].getExpressionString()));
            }
            buf.append((result = this.termArray[i].evaluate(vr)) != null ? result.toString() : EMPTY_STRING);
            ++i;
        }
        return buf.toString();
    }

    public void update(Object value, VariableResolver vr) {
        if (!this.isExpression) {
            String msg = "The expression can not be updated because it is not atomic.";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        this.atomicExpression.update(value, vr);
    }

    public String changeContext(String oldContext, String newContext, Object index) {
        if (!this.isExpression) {
            String msg = "The expression can not change context because it is not atomic.";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        return this.atomicExpression.changeContext(oldContext, newContext, index);
    }

    public String qualify(String contextName) {
        return "{" + contextName + "." + this.getExpressionString() + "}";
    }

    public String getExpressionString() {
        if (this.isExpression) {
            return this.atomicExpression.getExpressionString();
        }
        return this.exprStr;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.terms.size()) {
            buf.append(this.terms.get(i).toString());
            ++i;
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

