/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow.util;

import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.pageflow.util.PageflowTagUtils;
import com.bea.wlw.netui.pageflow.util.TemplateHelper;
import com.bea.wlw.netui.pageflow.util.URLRewriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultURLRewriter
extends URLRewriter {
    public String rewriteName(ServletContext servletContext, ServletRequest request, String name) {
        URLRewriter next = this.getNextRewriter();
        return next != null ? next.rewriteName(servletContext, request, name) : name;
    }

    public String rewriteURL(ServletContext servletContext, ServletRequest request, ServletResponse response, String url, String type) {
        URLRewriter next;
        TemplateHelper templateHelper = new TemplateHelper((HttpServletRequest)request, (HttpServletResponse)response);
        if (templateHelper.hasTemplateRef(type)) {
            templateHelper.setTemplate(templateHelper.getTemplateName(type));
            templateHelper.setUrl(url);
            url = templateHelper.toString();
        } else if (type.equals(URLRewriter.ACTION_SECURE) || type.equals(URLRewriter.RESOURCE_SECURE)) {
            if (!request.isSecure()) {
                url = this.internalRewriteUrl(url, "https", PageFlowUtils.getServerAdapter().getSecureListenPort((HttpServletRequest)request), request.getServerName());
            }
        } else if (request.isSecure()) {
            url = this.internalRewriteUrl(url, "http", PageFlowUtils.getServerAdapter().getListenPort((HttpServletRequest)request), request.getServerName());
        }
        String scopeID = request.getParameter("jpfScopeID");
        if (scopeID != null) {
            url = PageflowTagUtils.addParam(url, "jpfScopeID", scopeID);
        }
        return (next = this.getNextRewriter()) != null ? next.rewriteURL(servletContext, request, response, url, type) : url;
    }

    private String internalRewriteUrl(String url, String protocol, int port, String serverName) {
        if (!PageFlowUtils.isAbsoluteURI(url)) {
            StringBuffer urlBuf = new StringBuffer(protocol);
            urlBuf.append("://");
            urlBuf.append(serverName);
            urlBuf.append(":");
            urlBuf.append(port);
            urlBuf.append(url);
            url = urlBuf.toString();
        }
        return url;
    }
}

