/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow;

import com.bea.wlw.netui.pageflow.MultipartRequestUtils;
import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.pageflow.RequestParameterHandler;
import com.bea.wlw.netui.script.Expression;
import com.bea.wlw.netui.script.ExpressionEvaluator;
import com.bea.wlw.netui.script.ExpressionEvaluatorFactory;
import com.bea.wlw.netui.script.ExpressionUpdateException;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.PopulateContextHelper;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionForm;

public class ProcessPopulate {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$pageflow$ProcessPopulate == null ? (class$com$bea$wlw$netui$pageflow$ProcessPopulate = ProcessPopulate.class$("com.bea.wlw.netui.pageflow.ProcessPopulate")) : class$com$bea$wlw$netui$pageflow$ProcessPopulate));
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$pageflow$ProcessPopulate == null ? (class$com$bea$wlw$netui$pageflow$ProcessPopulate = ProcessPopulate.class$("com.bea.wlw.netui.pageflow.ProcessPopulate")) : class$com$bea$wlw$netui$pageflow$ProcessPopulate));
    private static final String PAGE_FLOW_CONTEXT = "pageFlow";
    private static final String GLOBAL_APP_CONTEXT = "globalApp";
    private static final String WLW_TAG_HANDLER_PREFIX = "wlw-";
    private static final String WLW_TAG_HANDLER_SUFFIX = ":";
    private static final Map handlerMap = new HashMap();
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$ProcessPopulate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPrefixHandler(String prefix, RequestParameterHandler handler) {
        Map map = handlerMap;
        synchronized (map) {
            String msg = "Register RequestParameterHandler with\n\tprefix: " + prefix + "\n\thandler: " + (handler != null ? handler.getClass().getName() : null);
            if (ProcessPopulate.debug.ON) {
                debug.out(msg);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)msg);
            }
            handlerMap.put(prefix, handler);
        }
    }

    public static String writeHandlerName(String handler, String expression) {
        if (!ExpressionEvaluatorFactory.getInstance().isExpression(expression)) {
            throw new IllegalArgumentException(Bundle.getErrorString((String)"ProcessPopulate_handler_nonAtomicExpression", (Object[])new Object[]{expression}));
        }
        if (!handlerMap.containsKey(handler)) {
            throw new IllegalStateException(Bundle.getErrorString((String)"ProcessPopulate_handler_notRegistered", (Object[])new Object[]{handler}));
        }
        StringBuffer buf = new StringBuffer();
        buf.append(WLW_TAG_HANDLER_PREFIX);
        buf.append(handler);
        buf.append(WLW_TAG_HANDLER_SUFFIX);
        buf.append(expression);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populate(HttpServletRequest request, HttpServletResponse response, ActionForm form, boolean requestHasPopulated) throws ServletException {
        String key = null;
        HashMap strutsProperties = null;
        ExpressionEvaluator ee = ExpressionEvaluatorFactory.getInstance();
        boolean isMultipart = false;
        Map params = MultipartRequestUtils.handleMultipartRequest(request, form);
        if (params != null) {
            isMultipart = true;
        } else {
            params = request.getParameterMap();
        }
        if (params == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"An error occurred checking a request for multipart status.  No model values were updated.");
            }
            return;
        }
        try {
            HashMap contextMap = new HashMap();
            PopulateContextHelper.populate(contextMap, (ServletRequest)request, (ServletResponse)response, (ActionForm)form);
            Iterator iterator = params.keySet().iterator();
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                if (ProcessPopulate.debug.ON) {
                    debug.out("key: " + key + " value type: " + params.get(key).getClass().getName() + " value: " + params.get(key));
                }
                try {
                    if (ee.containsExpression(key)) {
                        Object updateValue = null;
                        if (!isMultipart || params.get(key) instanceof String[]) {
                            String[] values = (String[])params.get(key);
                            if (key.startsWith(WLW_TAG_HANDLER_PREFIX)) {
                                if (ProcessPopulate.debug.ON) {
                                    debug.out("Found an expression requiring a TAG HANDLER");
                                }
                                ExpressionUpdateNode node = ProcessPopulate.doTagHandler(key, values, request);
                                key = node.expression;
                                values = node.values;
                            }
                            updateValue = values != null && values.length == 1 ? values[0] : values;
                        } else {
                            updateValue = params.get(key);
                        }
                        try {
                            if (!ee.isExpression(key)) continue;
                            if (!requestHasPopulated) {
                                ee.update(key, updateValue, contextMap, true);
                                continue;
                            }
                            Expression pe = ee.parseExpression(key);
                            String contextName = pe.getContext();
                            if (contextName.equals(PAGE_FLOW_CONTEXT) || contextName.equals(GLOBAL_APP_CONTEXT)) continue;
                            ee.update(key, updateValue, contextMap, true);
                        }
                        catch (ExpressionUpdateException e) {
                            String s = Bundle.getString((String)"ExprUpdateError", (Object[])new Object[]{key, e});
                            System.err.println(s);
                            if (logger.isErrorEnabled()) {
                                logger.error((Object)s);
                            }
                            PageFlowUtils.addBindingUpdateError((ServletRequest)request, key, s, e);
                        }
                        continue;
                    }
                    if (ProcessPopulate.debug.ON) {
                        debug.out("HTTP request parameter key \"" + key + "\" is not an expression, handle with Struts");
                    }
                    if (strutsProperties == null) {
                        strutsProperties = new HashMap();
                    }
                    strutsProperties.put(key, params.get(key));
                }
                catch (Exception e) {
                    String s = Bundle.getString((String)"ProcessPopulate_exprUpdateError", (Object[])new Object[]{key, e});
                    System.err.println(s);
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)s, (Throwable)e);
                    }
                    PageFlowUtils.addBindingUpdateError((ServletRequest)request, key, s, e);
                }
            }
            Object var15_16 = null;
            ee.exit();
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            ee.exit();
            throw throwable;
        }
        ProcessPopulate.handleStrutsProperties(strutsProperties, form);
    }

    static final ExpressionUpdateNode doTagHandler(String key, String[] values, HttpServletRequest request) {
        String handlerName;
        RequestParameterHandler handler;
        String[] _values = values;
        String expr = key;
        if (ProcessPopulate.debug.ON) {
            debug.out("Found prefixed tag; handlerName: " + key.substring(WLW_TAG_HANDLER_PREFIX.length(), key.indexOf(WLW_TAG_HANDLER_SUFFIX)));
        }
        if ((handler = (RequestParameterHandler)handlerMap.get(handlerName = key.substring(WLW_TAG_HANDLER_PREFIX.length(), key.indexOf(WLW_TAG_HANDLER_SUFFIX)))) != null) {
            expr = key.substring(key.indexOf(WLW_TAG_HANDLER_SUFFIX) + 1);
            if (ProcessPopulate.debug.ON) {
                debug.out("found handler for prefix \"" + handlerName + "\" type: " + (handler != null ? handler.getClass().getName() : null) + "\n\t" + "key: \"" + key + "\" expr: \"" + expr + "\"");
            }
            ExpressionUpdateNode node = new ExpressionUpdateNode();
            node.expression = expr;
            node.values = _values;
            handler.process(request, key, node);
            return node;
        }
        throw new IllegalStateException("Request parameter references a tag handler prefix \"" + handlerName + "\" that is not registered for expression \"" + key + "\"");
    }

    private static final void handleStrutsProperties(Map strutsProperties, ActionForm form) {
        if (strutsProperties != null) {
            if (ProcessPopulate.debug.ON) {
                debug.out("Handle Struts request parameters.");
            }
            try {
                BeanUtils.populate((Object)form, (Map)strutsProperties);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception processing bean and request parameters: ", e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class ExpressionUpdateNode {
        public String expression = null;
        public String[] values = null;

        private ExpressionUpdateNode() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("expression: " + this.expression + "\n");
            if (this.values != null) {
                int i = 0;
                while (i < this.values.length) {
                    buf.append("value[" + i + "]: " + this.values[i]);
                    ++i;
                }
            } else {
                buf.append("values are null");
            }
            return buf.toString();
        }
    }
}

