/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.opti;

import org.apache.xerces.impl.xs.opti.AttrImpl;
import org.apache.xerces.impl.xs.opti.DefaultDocument;
import org.apache.xerces.impl.xs.opti.ElementImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SchemaDOM
extends DefaultDocument {
    static final int relationsRowResizeFactor = 15;
    static final int relationsColResizeFactor = 10;
    ElementImpl[][] relations;
    ElementImpl parent;
    int currLoc;
    int nextFreeLoc;
    boolean hidden;

    public SchemaDOM() {
        this.reset();
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs, int line, int column) throws XNIException {
        ElementImpl node = new ElementImpl(line, column);
        this.processElement(element, attributes, augs, node);
        this.parent = node;
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs, int line, int column) throws XNIException {
        ElementImpl node = new ElementImpl(line, column);
        this.processElement(element, attributes, augs, node);
    }

    private void processElement(QName element, XMLAttributes attributes, Augmentations augs, ElementImpl node) throws XNIException {
        node.prefix = element.prefix;
        node.localpart = element.localpart;
        node.rawname = element.rawname;
        node.uri = element.uri;
        node.schemaDOM = this;
        Attr[] attrs = new Attr[attributes.getLength()];
        int i = 0;
        while (i < attributes.getLength()) {
            attrs[i] = new AttrImpl(null, attributes.getPrefix(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getURI(i), attributes.getValue(i));
            ++i;
        }
        node.attrs = attrs;
        if (this.nextFreeLoc == this.relations.length) {
            this.resizeRelations();
        }
        if (this.relations[this.currLoc][0] != this.parent) {
            this.relations[this.nextFreeLoc][0] = this.parent;
            this.currLoc = this.nextFreeLoc++;
        }
        boolean foundPlace = false;
        int i2 = 1;
        i2 = 1;
        while (i2 < this.relations[this.currLoc].length) {
            if (this.relations[this.currLoc][i2] == null) {
                foundPlace = true;
                break;
            }
            ++i2;
        }
        if (!foundPlace) {
            this.resizeRelations(this.currLoc);
        }
        this.relations[this.currLoc][i2] = node;
        this.parent.parentRow = this.currLoc;
        node.row = this.currLoc;
        node.col = i2;
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.currLoc = this.parent.row;
        this.parent = this.relations[this.currLoc][0];
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
    }

    private void resizeRelations() {
        ElementImpl[][] temp = new ElementImpl[this.relations.length + 15][];
        System.arraycopy(this.relations, 0, temp, 0, this.relations.length);
        int i = this.relations.length;
        while (i < temp.length) {
            temp[i] = new ElementImpl[10];
            ++i;
        }
        this.relations = temp;
    }

    private void resizeRelations(int i) {
        ElementImpl[] temp = new ElementImpl[this.relations[i].length + 10];
        System.arraycopy(this.relations[i], 0, temp, 0, this.relations[i].length);
        this.relations[i] = temp;
    }

    public void reset() {
        this.relations = new ElementImpl[15][];
        this.parent = new ElementImpl(0, 0);
        this.parent.rawname = "DOCUMENT_NODE";
        this.currLoc = 0;
        this.nextFreeLoc = 1;
        int i = 0;
        while (i < 15) {
            this.relations[i] = new ElementImpl[10];
            ++i;
        }
        this.relations[this.currLoc][0] = this.parent;
    }

    public void printDOM() {
    }

    public static void traverse(Node node, int depth) {
        SchemaDOM.indent(depth);
        System.out.print("<" + node.getNodeName());
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                System.out.print("  " + ((Attr)attrs.item(i)).getName() + "=\"" + ((Attr)attrs.item(i)).getValue() + "\"");
                ++i;
            }
        }
        if (node.hasChildNodes()) {
            System.out.println(">");
            depth += 4;
            Node child = node.getFirstChild();
            while (child != null) {
                SchemaDOM.traverse(child, depth);
                child = child.getNextSibling();
            }
            SchemaDOM.indent(depth -= 4);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    public static void indent(int amount) {
        int i = 0;
        while (i < amount) {
            System.out.print(' ');
            ++i;
        }
    }

    public Element getDocumentElement() {
        return this.relations[0][1];
    }
}

