/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.xni.QName;

public class SubstitutionGroupHandler {
    XSGrammarBucket fGrammarBucket;
    Hashtable fSubGroups = new Hashtable();
    private static final XSElementDecl[] EMPTY_VECTOR = new XSElementDecl[0];

    public SubstitutionGroupHandler(XSGrammarBucket grammarBucket) {
        this.fGrammarBucket = grammarBucket;
    }

    public XSElementDecl getMatchingElemDecl(QName element, XSElementDecl exemplar) {
        if (element.localpart == exemplar.fName && element.uri == exemplar.fTargetNamespace) {
            return exemplar;
        }
        if (exemplar.fScope != 1) {
            return null;
        }
        if ((exemplar.fBlock & 4) != 0) {
            return null;
        }
        SchemaGrammar sGrammar = this.fGrammarBucket.getGrammar(element.uri);
        if (sGrammar == null) {
            return null;
        }
        XSElementDecl eDecl = sGrammar.getGlobalElementDecl(element.localpart);
        if (eDecl == null) {
            return null;
        }
        if (this.substitutionGroupOK(eDecl, exemplar, exemplar.fBlock)) {
            return eDecl;
        }
        return null;
    }

    protected boolean substitutionGroupOK(XSElementDecl element, XSElementDecl exemplar, short blockingConstraint) {
        if ((blockingConstraint & 4) != 0) {
            return false;
        }
        int devMethod = 0;
        short blockConstraint = blockingConstraint;
        XSTypeDefinition type = element.fType;
        devMethod = type.getTypeCategory() == 13 ? (int)((XSComplexTypeDecl)type).fDerivedBy : 2;
        type = exemplar.fType;
        if (type.getTypeCategory() == 13) {
            blockConstraint = (short)(blockConstraint | ((XSComplexTypeDecl)type).fBlock);
        }
        XSElementDecl subGroup = element.fSubGroup;
        while (subGroup != null && subGroup != exemplar) {
            type = subGroup.fType;
            if (type.getTypeCategory() == 13) {
                devMethod = (short)(devMethod | ((XSComplexTypeDecl)type).fDerivedBy);
                blockConstraint = (short)(blockConstraint | ((XSComplexTypeDecl)type).fBlock);
            } else {
                devMethod = (short)(devMethod | 2);
            }
            subGroup = subGroup.fSubGroup;
        }
        if (subGroup == null) {
            return false;
        }
        return (devMethod & blockConstraint) == 0;
    }

    public boolean inSubstitutionGroup(XSElementDecl element, XSElementDecl exemplar) {
        while (element != null && element != exemplar) {
            element = element.fSubGroup;
        }
        return element != null;
    }

    public void reset() {
        this.fSubGroups.clear();
    }

    public void addSubstitutionGroup(XSElementDecl[] elements) {
        int i = elements.length - 1;
        while (i >= 0) {
            XSElementDecl element = elements[i];
            XSElementDecl subHead = element.fSubGroup;
            Vector<XSElementDecl> subGroup = (Vector<XSElementDecl>)this.fSubGroups.get(subHead);
            if (subGroup == null) {
                subGroup = new Vector<XSElementDecl>();
                this.fSubGroups.put(subHead, subGroup);
            }
            subGroup.addElement(element);
            --i;
        }
    }

    public XSElementDecl[] getSubstitutionGroup(XSElementDecl element) {
        XSElementDecl[] ret;
        Object subGroup = this.fSubGroups.get(element);
        if (subGroup == null) {
            ret = EMPTY_VECTOR;
            this.fSubGroups.put(element, ret);
        } else if (subGroup instanceof XSElementDecl[]) {
            ret = (XSElementDecl[])subGroup;
        } else {
            Vector group = (Vector)subGroup;
            int i = group.size() - 1;
            while (i >= 0) {
                XSElementDecl[] group1 = this.getSubstitutionGroup((XSElementDecl)group.elementAt(i));
                int j = group1.length - 1;
                while (j >= 0) {
                    group.addElement(group1[j]);
                    --j;
                }
                --i;
            }
            ret = new XSElementDecl[group.size()];
            int i2 = group.size() - 1;
            while (i2 >= 0) {
                ret[i2] = (XSElementDecl)group.elementAt(i2);
                --i2;
            }
            this.fSubGroups.put(element, ret);
        }
        return ret;
    }
}

