/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.html;

import com.bea.wlw.netui.pageflow.util.PageflowTagUtils;
import com.bea.wlw.netui.tags.AbstractBaseTag;
import com.bea.wlw.netui.tags.EvalErrorInfo;
import com.bea.wlw.netui.tags.html.Tree;
import com.bea.wlw.netui.tags.html.TreeNode;
import com.bea.wlw.netui.util.Bundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

public class Node
extends AbstractBaseTag {
    protected String action;
    protected String expanded;
    protected String href;
    protected String icon;
    protected String label;
    protected TreeNode node = null;
    protected String target;

    public String getTagName() {
        return "Node";
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getExpanded() {
        return this.expanded;
    }

    public void setExpanded(String expanded) {
        this.expanded = expanded;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public TreeNode getNode() {
        return this.node;
    }

    public void setNode(TreeNode node) {
        this.node = node;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void registerError(EvalErrorInfo error) {
        Tree parentTree = this.getParentTree();
        if (parentTree != null) {
            parentTree.registerError(error);
        } else {
            super.registerError(error);
        }
    }

    public String registerTagError(String message) {
        System.err.println("Error in Node");
        String s = null;
        Tree parentTree = this.getParentTree();
        s = parentTree != null ? parentTree.registerTagError(s) : super.registerTagError(s);
        return s;
    }

    public int doStartTag() throws JspException {
        int have = 0;
        if (this.href != null) {
            ++have;
        }
        if (this.action != null) {
            ++have;
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        if (this.containsExpression(this.label)) {
            Object val = this.evaluateExpression(this.label, "label");
            this.label = val != null ? val.toString() : "";
        }
        if (have > 1) {
            String s = Bundle.getString((String)"Tags_Node_InvalidNode", (Object[])new Object[]{this.label, "href, action"});
            this.registerTagError(s);
            return 0;
        }
        boolean isExpanded = false;
        if (this.expanded != null) {
            isExpanded = new Boolean(this.expanded);
        }
        boolean isAction = true;
        if (this.action != null) {
            isAction = PageflowTagUtils.isAction((HttpServletRequest)request, (HttpServletResponse)response, (ServletContext)this.pageContext.getServletContext(), (String)this.action);
        }
        if (isAction) {
            this.node = new TreeNode(this.icon, this.label, this.action, this.href, this.target, isExpanded);
        } else {
            Tree parentTree = (Tree)this.getParent();
            this.registerTagError(Bundle.getString((String)"Tags_BadAction", (Object)this.action));
        }
        if (this.hasErrors()) {
            return 0;
        }
        Tag parentTag = this.getParent();
        if (parentTag instanceof Tree) {
            Tree parentTree = (Tree)parentTag;
            if (parentTree.getRootNode() != null) {
                String s = Bundle.getString((String)"Tags_TreeMultipleRootNodes");
                s = parentTree.registerTagError(s);
                return 0;
            }
            this.node.setLast(true);
            parentTree.setRootNode(this.node);
        } else if (parentTag instanceof Node) {
            Node parentNode = (Node)parentTag;
            parentNode.getNode().addChild(this.node);
        } else {
            throw new JspException(Bundle.getString((String)"Tags_InvalidNodeParent"));
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        this.localRelease();
        return 6;
    }

    protected void localRelease() {
        super.localRelease();
        this.action = null;
        this.expanded = null;
        this.href = null;
        this.icon = null;
        this.label = null;
        this.node = null;
        this.target = null;
    }

    private Tree getParentTree() {
        Tag parentTag = this.getParent();
        while (parentTag != null) {
            if (parentTag instanceof Tree) {
                return (Tree)parentTag;
            }
            parentTag = parentTag.getParent();
        }
        return null;
    }
}

