/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.ui;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import cards.pay.paycardsrecognizer.sdk.Card;
import cards.pay.paycardsrecognizer.sdk.R;
import cards.pay.paycardsrecognizer.sdk.camera.RecognitionAvailabilityChecker;
import cards.pay.paycardsrecognizer.sdk.camera.RecognitionCoreUtils;
import cards.pay.paycardsrecognizer.sdk.camera.RecognitionUnavailableException;
import cards.pay.paycardsrecognizer.sdk.ui.InitLibraryFragment;
import cards.pay.paycardsrecognizer.sdk.ui.InlineViewCallback;
import cards.pay.paycardsrecognizer.sdk.ui.ScanCardFragment;

public class InlineViewFragment
extends Fragment
implements ScanCardFragment.InteractionListener,
InitLibraryFragment.InteractionListener {
    private InlineViewCallback callback;

    private void showScanCard() {
        ScanCardFragment scanCardFragment;
        InlineViewFragment inlineViewFragment = fragment;
        Fragment fragment = scanCardFragment;
        scanCardFragment = new ScanCardFragment();
        inlineViewFragment.getChildFragmentManager().beginTransaction().replace(R.id.inline_content, fragment, "ScanCardFragment").setCustomAnimations(0, 0).commitNow();
        ViewCompat.requestApplyInsets((View)inlineViewFragment.getView().findViewById(R.id.inline_content));
    }

    private void showInitLibrary() {
        InitLibraryFragment initLibraryFragment;
        InlineViewFragment inlineViewFragment = fragment;
        Fragment fragment = initLibraryFragment;
        initLibraryFragment = new InitLibraryFragment();
        inlineViewFragment.getChildFragmentManager().beginTransaction().replace(R.id.inline_content, fragment, "InitLibraryFragment").setCustomAnimations(0, 0).commitNow();
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.fragment_inline_view, viewGroup, false);
    }

    public void onViewCreated(@NonNull View object, @Nullable Bundle bundle) {
        super.onViewCreated((View)object, bundle);
        if (bundle == null) {
            object = RecognitionAvailabilityChecker.doCheck((Context)this.getActivity());
            if (((RecognitionAvailabilityChecker.Result)object).isFailed() && !((RecognitionAvailabilityChecker.Result)object).isFailedOnCameraPermission()) {
                this.onScanCardFailed(new RecognitionUnavailableException(((RecognitionAvailabilityChecker.Result)object).getMessage()));
            } else if (!RecognitionCoreUtils.isRecognitionCoreDeployRequired((Context)this.getActivity()) && !((RecognitionAvailabilityChecker.Result)object).isFailedOnCameraPermission()) {
                this.showScanCard();
            } else {
                this.showInitLibrary();
            }
        }
    }

    @Override
    public void onInitLibraryFailed(Throwable throwable) {
        RuntimeException runtimeException;
        RuntimeException runtimeException2 = runtimeException;
        runtimeException = new RuntimeException("onInitLibraryFailed()", throwable);
        Log.e((String)"ScanInlineView", (String)"Init library failed", (Throwable)runtimeException2);
    }

    @Override
    public void onInitLibraryComplete() {
        this.showScanCard();
    }

    @Override
    public void onScanCardFailed(Exception exception) {
        this.callback.onScanCardFailed(exception);
    }

    @Override
    public void onScanCardFinished(Card card, byte[] byArray) {
        this.callback.onScanCardFinished(card, byArray);
    }
}

