/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera;

import android.hardware.Camera;
import android.support.annotation.RestrictTo;
import cards.pay.paycardsrecognizer.sdk.camera.CameraConfigurationUtils;
import cards.pay.paycardsrecognizer.sdk.ndk.RecognitionCore;
import cards.pay.paycardsrecognizer.sdk.ndk.TorchStatusListener;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TorchManager {
    private final Camera mCamera;
    private boolean mPaused;
    private boolean mTorchTurnedOn;
    private final RecognitionCore mRecognitionCore;
    private final TorchStatusListener mRecognitionCoreTorchStatusListener;

    public TorchManager(RecognitionCore recognitionCore, Camera camera) {
        TorchStatusListener torchStatusListener;
        TorchStatusListener torchStatusListener2 = torchStatusListener;
        torchStatusListener = new TorchStatusListener(){

            @Override
            public void onTorchStatusChanged(boolean bl) {
                if (TorchManager.this.mCamera == null) {
                    return;
                }
                if (bl) {
                    1 v0 = this;
                    TorchManager.access$102(v0.TorchManager.this, true);
                    if (!v0.TorchManager.this.mPaused) {
                        CameraConfigurationUtils.setFlashLight(TorchManager.this.mCamera, true);
                    }
                } else {
                    1 v1 = this;
                    TorchManager.access$102(v1.TorchManager.this, false);
                    CameraConfigurationUtils.setFlashLight(v1.TorchManager.this.mCamera, false);
                }
            }
        };
        this.mRecognitionCoreTorchStatusListener = torchStatusListener2;
        this.mCamera = camera;
        this.mRecognitionCore = recognitionCore;
    }

    private boolean isTorchTurnedOn() {
        String string = ((TorchManager)((Object)string)).mCamera.getParameters().getFlashMode();
        return "torch".equals(string) || "on".equals(string);
    }

    static /* synthetic */ boolean access$102(TorchManager torchManager, boolean bl) {
        torchManager.mTorchTurnedOn = bl;
        return bl;
    }

    public void pause() {
        TorchManager torchManager = this;
        CameraConfigurationUtils.setFlashLight(torchManager.mCamera, false);
        torchManager.mPaused = true;
        torchManager.mRecognitionCore.setTorchListener(null);
    }

    public void resume() {
        TorchManager torchManager = this;
        torchManager.mPaused = false;
        torchManager.mRecognitionCore.setTorchListener(this.mRecognitionCoreTorchStatusListener);
        if (torchManager.mTorchTurnedOn) {
            this.mRecognitionCore.setTorchStatus(true);
        } else {
            this.mRecognitionCore.setTorchStatus(false);
        }
    }

    public void destroy() {
        this.mRecognitionCore.setTorchListener(null);
    }

    public void toggleTorch() {
        if (this.mPaused) {
            return;
        }
        TorchManager torchManager = this;
        boolean bl = torchManager.isTorchTurnedOn() ^ true;
        torchManager.mRecognitionCore.setTorchStatus(bl);
        CameraConfigurationUtils.setFlashLight(torchManager.mCamera, bl);
    }
}

