/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.ndk;

import android.annotation.SuppressLint;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.view.Display;
import cards.pay.paycardsrecognizer.sdk.ndk.DisplayConfiguration;
import cards.pay.paycardsrecognizer.sdk.ndk.DisplayHelper;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DisplayConfigurationImpl
implements DisplayConfiguration {
    private int mDisplayRotation;
    private boolean mNaturalOrientationIsLandscape;
    private int mCameraSensorRotation = 0;
    private int mPreprocessFrameRotation = 0;

    private void refreshPreprocessFrameRotation() {
        DisplayConfigurationImpl displayConfigurationImpl = this;
        int n = DisplayHelper.getCameraRotationToNatural(displayConfigurationImpl.mDisplayRotation, this.mCameraSensorRotation, false);
        int n2 = displayConfigurationImpl.getNativeDisplayRotation();
        if (n2 == 3 || n2 == 4) {
            n = (n + 360 - 90) % 360;
        }
        this.mPreprocessFrameRotation = n;
    }

    private boolean sanityCheckPreprocessFrameRotation(int n, int n2, int n3) {
        boolean bl = n2 >= n;
        n = n3 != 90 && n3 != 270 ? 0 : 1;
        return (!bl || n == 0) && (bl || n != 0);
    }

    public void setDisplayParameters(Display display) {
        Display display2 = display;
        int n = DisplayHelper.getDisplayRotationDegrees(display2);
        this.setDisplayParameters(n, DisplayHelper.naturalOrientationIsLandscape(display2));
    }

    @VisibleForTesting
    void setDisplayParameters(int n, boolean bl) {
        this.mDisplayRotation = n;
        this.mNaturalOrientationIsLandscape = bl;
        this.refreshPreprocessFrameRotation();
    }

    public void setCameraParameters(int n) {
        this.mCameraSensorRotation = n;
        this.refreshPreprocessFrameRotation();
    }

    @Override
    public int getNativeDisplayRotation() {
        DisplayConfigurationImpl displayConfigurationImpl = this;
        int n = displayConfigurationImpl.mDisplayRotation;
        if (displayConfigurationImpl.mNaturalOrientationIsLandscape) {
            n = (n + 360 + -90) % 360;
        }
        if (n != 0) {
            if (n != 90) {
                if (n != 180) {
                    if (n == 270) {
                        return 4;
                    }
                    throw new IllegalStateException();
                }
                return 2;
            }
            return 3;
        }
        return 1;
    }

    @Override
    @SuppressLint(value={"Range"})
    public int getPreprocessFrameRotation(int n, int n2) {
        if (!this.sanityCheckPreprocessFrameRotation(n, n2, this.mPreprocessFrameRotation)) {
            return -1;
        }
        return this.mPreprocessFrameRotation;
    }

    public String toString() {
        return "DisplayConfigurationImpl{mCameraSensorRotation=" + this.mCameraSensorRotation + ", mDisplayRotation=" + this.mDisplayRotation + ", mNaturalOrientationIsLandscape=" + this.mNaturalOrientationIsLandscape + ", mPreprocessFrameRotation=" + this.mPreprocessFrameRotation + '}';
    }
}

