/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera;

import android.hardware.Camera;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.view.Display;
import cards.pay.paycardsrecognizer.sdk.camera.BlockingOperationException;
import cards.pay.paycardsrecognizer.sdk.camera.OrientationHelper;
import cards.pay.paycardsrecognizer.sdk.utils.Size;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class CameraUtils {
    public static final NativeSupportedSize CAMERA_RESOLUTION = NativeSupportedSize.RESOLUTION_1280_X_720;
    private static NativeSupportedSize sBestCameraPreviewSize;

    public static boolean isCameraSupported() throws BlockingOperationException {
        NativeSupportedSize nativeSupportedSize = sBestCameraPreviewSize;
        if (nativeSupportedSize != null) {
            return nativeSupportedSize != NativeSupportedSize.RESOLUTION_NO_CAMERA;
        }
        throw new BlockingOperationException();
    }

    @Nullable
    public static NativeSupportedSize findBestCameraSupportedSize(Iterable<Camera.Size> object) {
        NativeSupportedSize nativeSupportedSize = NativeSupportedSize.RESOLUTION_NO_CAMERA;
        if (object == null) {
            return nativeSupportedSize;
        }
        object = object.iterator();
        while (object.hasNext()) {
            NativeSupportedSize nativeSupportedSize22;
            block3: {
                Camera.Size size = (Camera.Size)object.next();
                for (NativeSupportedSize nativeSupportedSize22 : NativeSupportedSize.values()) {
                    Size size2 = nativeSupportedSize22.size;
                    if (size.width != size2.width || size.height != size2.height) continue;
                    if (nativeSupportedSize22.compareTo(nativeSupportedSize) >= 0) break;
                    break block3;
                }
                nativeSupportedSize22 = nativeSupportedSize;
            }
            nativeSupportedSize = nativeSupportedSize22;
        }
        return nativeSupportedSize;
    }

    @Nullable
    public static Camera.CameraInfo getBackCameraInfo() {
        Camera.CameraInfo cameraInfo;
        int n = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < n; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo2);
            if (cameraInfo2.facing != 0) continue;
            return cameraInfo2;
        }
        return null;
    }

    public static int getBackCameraSensorOrientation() {
        Camera.CameraInfo cameraInfo = CameraUtils.getBackCameraInfo();
        return cameraInfo == null ? 0 : cameraInfo.orientation;
    }

    public static int getBackCameraDataRotation(Display display) {
        return CameraUtils.getCameraDataRotation(display, CameraUtils.getBackCameraInfo());
    }

    private static int getCameraDataRotation(Display display, @Nullable Camera.CameraInfo cameraInfo) {
        int n = OrientationHelper.getDisplayRotationDegrees(display);
        if (cameraInfo == null) {
            return 0;
        }
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        int n2 = cameraInfo2.orientation;
        boolean bl = cameraInfo2.facing == 1;
        return OrientationHelper.getCameraRotationToNatural(n, n2, bl);
    }

    public static final class NativeSupportedSize
    extends Enum<NativeSupportedSize> {
        public static final /* enum */ NativeSupportedSize RESOLUTION_1280_X_720;
        public static final /* enum */ NativeSupportedSize RESOLUTION_NO_CAMERA;
        private static final /* synthetic */ NativeSupportedSize[] $VALUES;
        public final Size size;

        public static NativeSupportedSize[] values() {
            return (NativeSupportedSize[])$VALUES.clone();
        }

        public static NativeSupportedSize valueOf(String string2) {
            return Enum.valueOf(NativeSupportedSize.class, string2);
        }

        private NativeSupportedSize(int n2, int n3) {
            Size size;
            Object object = size;
            size = new Size(n2, n3);
            v1.size = object;
        }

        static {
            NativeSupportedSize nativeSupportedSize;
            RESOLUTION_1280_X_720 = new NativeSupportedSize(1280, 720);
            NativeSupportedSize nativeSupportedSize2 = nativeSupportedSize;
            RESOLUTION_NO_CAMERA = new NativeSupportedSize(-1, -1);
            $VALUES = new NativeSupportedSize[]{RESOLUTION_1280_X_720, nativeSupportedSize2};
        }
    }
}

