/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.ndk;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class RecognitionResult
implements Parcelable {
    private static final RecognitionResult sEmpty = new Builder().setIsFirst(true).build();
    public static final Parcelable.Creator<RecognitionResult> CREATOR = new Parcelable.Creator<RecognitionResult>(){

        public RecognitionResult createFromParcel(Parcel parcel) {
            return new RecognitionResult(parcel);
        }

        public RecognitionResult[] newArray(int n) {
            return new RecognitionResult[n];
        }
    };
    @Nullable
    private final String number;
    @Nullable
    private final String date;
    @Nullable
    private final String name;
    @Nullable
    private final String nameRaw;
    @Nullable
    private final Rect numberImageRect;
    @Nullable
    private final Bitmap cardImage;
    private final boolean isFirst;
    private final boolean isFinal;

    public static RecognitionResult empty() {
        return sEmpty;
    }

    public RecognitionResult(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Rect rect, @Nullable String string4, @Nullable Bitmap bitmap, boolean bl, boolean bl2) {
        this.number = string;
        this.name = string2;
        this.date = string3;
        this.nameRaw = string4;
        this.cardImage = bitmap;
        this.numberImageRect = rect;
        this.isFirst = bl;
        this.isFinal = bl2;
    }

    private RecognitionResult(Builder builder) {
        this.cardImage = builder.cardImage;
        this.number = builder.number;
        this.date = builder.date;
        this.name = builder.name;
        this.nameRaw = builder.nameRaw;
        this.numberImageRect = builder.numberImageRect;
        this.isFirst = builder.isFirst;
        this.isFinal = builder.isFinal;
    }

    protected RecognitionResult(Parcel parcel) {
        boolean bl = parcel.readInt() != 0;
        this.isFirst = bl;
        bl = parcel.readInt() != 0;
        this.isFinal = bl;
        this.number = parcel.readString();
        this.date = parcel.readString();
        this.name = parcel.readString();
        this.nameRaw = parcel.readString();
        this.numberImageRect = (Rect)parcel.readParcelable(Rect.class.getClassLoader());
        this.cardImage = (Bitmap)parcel.readParcelable(Bitmap.class.getClassLoader());
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    @Nullable
    public String getNumber() {
        return this.number;
    }

    @Nullable
    public String getDate() {
        return this.date;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getNameRaw() {
        return this.nameRaw;
    }

    @Nullable
    public Bitmap getCardImage() {
        return this.cardImage;
    }

    @Nullable
    public Rect getNumberImageRect() {
        return this.numberImageRect;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public int getCardImageWidth() {
        return this.getCardImage() == null ? 0 : this.getCardImage().getWidth();
    }

    public int getCardImageHeight() {
        return this.getCardImage() == null ? 0 : this.getCardImage().getHeight();
    }

    public boolean equals(Object object) {
        if (recognitionResult == object) {
            return true;
        }
        if (object != null && RecognitionResult.class == object.getClass()) {
            object = (RecognitionResult)object;
            if (recognitionResult.isFirst != ((RecognitionResult)object).isFirst) {
                return false;
            }
            if (recognitionResult.isFinal != ((RecognitionResult)object).isFinal) {
                return false;
            }
            String string = recognitionResult.number;
            if (string != null ? !string.equals(((RecognitionResult)object).number) : ((RecognitionResult)object).number != null) {
                return false;
            }
            string = recognitionResult.date;
            if (string != null ? !string.equals(((RecognitionResult)object).date) : ((RecognitionResult)object).date != null) {
                return false;
            }
            string = recognitionResult.name;
            if (string != null ? !string.equals(((RecognitionResult)object).name) : ((RecognitionResult)object).name != null) {
                return false;
            }
            string = recognitionResult.nameRaw;
            if (string != null ? !string.equals(((RecognitionResult)object).nameRaw) : ((RecognitionResult)object).nameRaw != null) {
                return false;
            }
            string = recognitionResult.numberImageRect;
            if (string != null ? !string.equals((Object)((RecognitionResult)object).numberImageRect) : ((RecognitionResult)object).numberImageRect != null) {
                return false;
            }
            RecognitionResult recognitionResult = recognitionResult.cardImage;
            return recognitionResult != null ? ((Object)recognitionResult).equals(((RecognitionResult)object).cardImage) : ((RecognitionResult)object).cardImage == null;
        }
        return false;
    }

    public int hashCode() {
        String string = this.number;
        int n = (string != null ? string.hashCode() : 0) * 31;
        String string2 = this.date;
        int n2 = string2 != null ? string2.hashCode() : 0;
        n = (n + n2) * 31;
        String string3 = this.name;
        int n3 = string3 != null ? string3.hashCode() : 0;
        n = (n + n3) * 31;
        String string4 = this.nameRaw;
        int n4 = string4 != null ? string4.hashCode() : 0;
        n = (n + n4) * 31;
        Rect rect = this.numberImageRect;
        int n5 = rect != null ? rect.hashCode() : 0;
        n = (n + n5) * 31;
        Bitmap bitmap = this.cardImage;
        int n6 = bitmap != null ? bitmap.hashCode() : 0;
        return ((n + n6) * 31 + this.isFirst) * 31 + this.isFinal;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.isFirst ? 1 : 0);
        parcel.writeInt(this.isFinal ? 1 : 0);
        parcel.writeString(this.number);
        parcel.writeString(this.date);
        parcel.writeString(this.name);
        parcel.writeString(this.nameRaw);
        parcel.writeParcelable((Parcelable)this.numberImageRect, 0);
        parcel.writeParcelable((Parcelable)this.cardImage, 0);
    }

    public static final class Builder {
        private boolean isFirst = true;
        private boolean isFinal = true;
        private Bitmap cardImage;
        private String number;
        private String date;
        private String name;
        private String nameRaw;
        private Rect numberImageRect;

        public Builder() {
        }

        public Builder(RecognitionResult recognitionResult) {
            this.isFirst = recognitionResult.isFirst;
            this.isFinal = recognitionResult.isFinal;
            this.cardImage = recognitionResult.cardImage;
            this.number = recognitionResult.number;
            this.date = recognitionResult.date;
            this.name = recognitionResult.name;
            this.nameRaw = recognitionResult.nameRaw;
            this.numberImageRect = recognitionResult.numberImageRect;
        }

        public Builder setCardImage(Bitmap bitmap) {
            this.cardImage = bitmap;
            return this;
        }

        public Builder setNumber(String string) {
            this.number = string;
            return this;
        }

        public Builder setDate(String string) {
            this.date = string;
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setNameRaw(String string) {
            this.nameRaw = string;
            return this;
        }

        public Builder setNumberImageRect(Rect rect) {
            this.numberImageRect = rect;
            return this;
        }

        public Builder setIsFinal(boolean bl) {
            this.isFinal = bl;
            return this;
        }

        public Builder setIsFirst(boolean bl) {
            this.isFirst = bl;
            return this;
        }

        public RecognitionResult build() {
            return new RecognitionResult(this);
        }
    }
}

