/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import cards.pay.paycardsrecognizer.FrameManager;
import cards.pay.paycardsrecognizer.sdk.R;
import cards.pay.paycardsrecognizer.sdk.camera.widget.CardRectCoordsMapper;
import cards.pay.paycardsrecognizer.sdk.ndk.RecognitionResult;
import cards.pay.paycardsrecognizer.sdk.utils.CardUtils;
import cards.pay.paycardsrecognizer.sdk.utils.Fonts;

public class CardDetectionStateView
extends View {
    private volatile int mDetectionState;
    private volatile String mRecognitionResultDate;
    private volatile String mRecognitionResultCardNumber;
    private volatile String mRecognitionResultHolder;
    private CardRectCoordsMapper mCardFrame;
    private float mDisplayDensity;
    private Typeface mCardTypeface;
    private final Rect mCardRectInvalidation;
    private float mCornerPaddingLeft;
    private float mCornerPaddingTop;
    private float mCornerLineWidth;
    private float mCornerRadius;
    private Drawable mCardGradientDrawable;
    private BitmapDrawable mCornerTopLeftDrawable;
    private BitmapDrawable mCornerTopRightDrawable;
    private BitmapDrawable mCornerBottomLeftDrawable;
    private BitmapDrawable mCornerBottomRightDrawable;
    private BitmapDrawable mLineTopDrawable;
    private BitmapDrawable mLineLeftDrawable;
    private BitmapDrawable mLineRightDrawable;
    private BitmapDrawable mLineBottomDrawable;
    private Paint mBackgroundPaint;
    private Paint mCardNumberPaint;
    private Paint mCardDatePaint;
    private Paint mCardHolderPaint;

    public CardDetectionStateView(Context context) {
        this(context, null);
    }

    public CardDetectionStateView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CardDetectionStateView(Context context, AttributeSet attributeSet, int n) {
        Rect rect;
        CardDetectionStateView cardDetectionStateView = cardDetectionStateView2;
        super(context, attributeSet, n);
        CardDetectionStateView cardDetectionStateView2 = rect;
        rect = new Rect();
        cardDetectionStateView.mCardRectInvalidation = cardDetectionStateView2;
        cardDetectionStateView.init(context);
    }

    private void init(Context context) {
        Paint paint;
        Paint paint2;
        float f;
        CardDetectionStateView cardDetectionStateView = this;
        float f2 = this.getResources().getDisplayMetrics().density;
        float f3 = f = f2;
        CardDetectionStateView cardDetectionStateView2 = this;
        CardDetectionStateView cardDetectionStateView3 = this;
        cardDetectionStateView3.mDisplayDensity = f;
        cardDetectionStateView3.mCardFrame = new CardRectCoordsMapper();
        int n = context.getResources().getColor(R.color.wocr_card_shadow_color);
        cardDetectionStateView2.mCornerPaddingTop = f *= 1.0f;
        cardDetectionStateView2.mCornerPaddingLeft = f;
        this.mCornerLineWidth = f3 * 5.0f;
        this.mCornerRadius = f2 * 8.0f;
        this.mCardGradientDrawable = context.getResources().getDrawable(R.drawable.wocr_frame_rect_gradient);
        this.initCornerDrawables(context);
        this.initLineDrawables(context);
        Paint paint3 = paint2 = paint;
        paint3();
        this.mBackgroundPaint = paint3;
        paint.setColor(n);
        cardDetectionStateView.mCardTypeface = Fonts.getCardFont(context);
        cardDetectionStateView.mCardNumberPaint = cardDetectionStateView.createCardTextPaint();
        cardDetectionStateView.mCardDatePaint = cardDetectionStateView.createCardTextPaint();
        cardDetectionStateView.mCardHolderPaint = cardDetectionStateView.createCardTextPaint();
        if (cardDetectionStateView.isInEditMode()) {
            CardDetectionStateView cardDetectionStateView4 = this;
            cardDetectionStateView4.mDetectionState = 15;
            cardDetectionStateView4.mRecognitionResultCardNumber = CardUtils.prettyPrintCardNumber("1234567890123456");
            cardDetectionStateView4.mRecognitionResultDate = "05/18";
            cardDetectionStateView4.mRecognitionResultHolder = "CARDHOLDER NAME";
        }
    }

    private Paint createCardTextPaint() {
        Paint paint;
        Paint paint2;
        Paint paint3 = paint2 = paint;
        paint2(193);
        paint3.setTypeface(this.mCardTypeface);
        paint3.setColor(-1);
        paint3.setShadowLayer(6.0f, 3.0f, 3.0f, -16777216);
        paint.setTextSize(this.mDisplayDensity * 12.0f);
        return paint;
    }

    private void initCornerDrawables(Context context) {
        Matrix matrix;
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mCornerTopLeftDrawable = (BitmapDrawable)context.getResources().getDrawable(R.drawable.wocr_card_frame_rect_corner_top_left);
        Matrix matrix2 = matrix;
        matrix2();
        Bitmap bitmap = this.mCornerTopLeftDrawable.getBitmap();
        matrix2.setRotate(90.0f);
        Bitmap bitmap2 = bitmap;
        Resources resources = context.getResources();
        int n = bitmap2.getWidth();
        int n2 = bitmap2.getHeight();
        this.mCornerTopRightDrawable = new BitmapDrawable(resources, Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true));
        matrix2.setRotate(180.0f);
        Bitmap bitmap3 = bitmap;
        resources = context.getResources();
        n = bitmap3.getWidth();
        n2 = bitmap3.getHeight();
        this.mCornerBottomRightDrawable = new BitmapDrawable(resources, Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true));
        matrix.setRotate(270.0f);
        Bitmap bitmap4 = bitmap;
        context = context.getResources();
        int n3 = bitmap4.getWidth();
        int n4 = bitmap4.getHeight();
        cardDetectionStateView.mCornerBottomLeftDrawable = new BitmapDrawable((Resources)context, Bitmap.createBitmap((Bitmap)bitmap4, (int)0, (int)0, (int)n3, (int)n4, (Matrix)matrix2, (boolean)true));
        if (FrameManager.getInstance().getFrameColor() != 0) {
            this.initCornerColor(FrameManager.getInstance().getFrameColor());
        }
    }

    private void initCornerColor(@ColorInt int n) {
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mCornerTopLeftDrawable.setTint(n);
        cardDetectionStateView.mCornerTopRightDrawable.setTint(n);
        cardDetectionStateView.mCornerBottomRightDrawable.setTint(n);
        cardDetectionStateView.mCornerBottomLeftDrawable.setTint(n);
    }

    private void initLineDrawables(Context context) {
        Matrix matrix;
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mLineTopDrawable = (BitmapDrawable)context.getResources().getDrawable(R.drawable.wocr_card_frame_rect_line_top);
        Matrix matrix2 = matrix;
        matrix2();
        Bitmap bitmap = this.mLineTopDrawable.getBitmap();
        matrix2.setRotate(90.0f);
        Bitmap bitmap2 = bitmap;
        Resources resources = context.getResources();
        int n = bitmap2.getWidth();
        int n2 = bitmap2.getHeight();
        this.mLineRightDrawable = new BitmapDrawable(resources, Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true));
        matrix2.setRotate(180.0f);
        Bitmap bitmap3 = bitmap;
        resources = context.getResources();
        n = bitmap3.getWidth();
        n2 = bitmap3.getHeight();
        this.mLineBottomDrawable = new BitmapDrawable(resources, Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true));
        matrix.setRotate(270.0f);
        Bitmap bitmap4 = bitmap;
        context = context.getResources();
        int n3 = bitmap4.getWidth();
        int n4 = bitmap4.getHeight();
        cardDetectionStateView.mLineLeftDrawable = new BitmapDrawable((Resources)context, Bitmap.createBitmap((Bitmap)bitmap4, (int)0, (int)0, (int)n3, (int)n4, (Matrix)matrix2, (boolean)true));
        if (FrameManager.getInstance().getFrameColor() != 0) {
            this.initLineColor(FrameManager.getInstance().getFrameColor());
        }
    }

    private void initLineColor(@ColorInt int n) {
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mLineTopDrawable.setTint(n);
        cardDetectionStateView.mLineRightDrawable.setTint(n);
        cardDetectionStateView.mLineBottomDrawable.setTint(n);
        cardDetectionStateView.mLineLeftDrawable.setTint(n);
    }

    private void drawBackground(Canvas canvas) {
        Canvas canvas2 = canvas;
        Canvas canvas3 = canvas;
        Canvas canvas4 = canvas;
        CardDetectionStateView cardDetectionStateView = this;
        Canvas canvas5 = canvas;
        CardDetectionStateView cardDetectionStateView2 = this;
        canvas = cardDetectionStateView2.mCardFrame.getCardRect();
        float f = this.getWidth();
        float f2 = canvas.top;
        Paint paint = cardDetectionStateView2.mBackgroundPaint;
        canvas5.drawRect(0.0f, 0.0f, f, f2, paint);
        f = canvas.bottom;
        f2 = cardDetectionStateView.getWidth();
        float f3 = cardDetectionStateView.getHeight();
        Paint paint2 = cardDetectionStateView.mBackgroundPaint;
        canvas4.drawRect(0.0f, f, f2, f3, paint2);
        Canvas canvas6 = canvas;
        f = canvas6.top;
        f2 = canvas6.left;
        f3 = canvas6.bottom;
        paint2 = this.mBackgroundPaint;
        canvas3.drawRect(0.0f, f, f2, f3, paint2);
        Canvas canvas7 = canvas;
        float f4 = canvas7.right;
        float f5 = canvas7.top;
        f = this.getWidth();
        f2 = canvas.bottom;
        Paint paint3 = this.mBackgroundPaint;
        canvas2.drawRect(f4, f5, f, f2, paint3);
    }

    private void drawCorners(Canvas canvas) {
        int n = this.mDetectionState;
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mCardGradientDrawable.draw(canvas);
        cardDetectionStateView.mCornerTopLeftDrawable.draw(canvas);
        cardDetectionStateView.mCornerTopRightDrawable.draw(canvas);
        cardDetectionStateView.mCornerBottomLeftDrawable.draw(canvas);
        cardDetectionStateView.mCornerBottomRightDrawable.draw(canvas);
        if ((n & 1) != 0) {
            this.mLineTopDrawable.draw(canvas);
        }
        if ((n & 4) != 0) {
            this.mLineLeftDrawable.draw(canvas);
        }
        if ((n & 8) != 0) {
            this.mLineRightDrawable.draw(canvas);
        }
        if ((n & 2) != 0) {
            this.mLineBottomDrawable.draw(canvas);
        }
    }

    private void drawRecognitionResult(Canvas canvas) {
        CardDetectionStateView cardDetectionStateView = this;
        String string2 = cardDetectionStateView.mRecognitionResultDate;
        String string3 = cardDetectionStateView.mRecognitionResultCardNumber;
        String string4 = cardDetectionStateView.mRecognitionResultHolder;
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            CardDetectionStateView cardDetectionStateView2 = this;
            float f = cardDetectionStateView2.mCardFrame.getCardNumberPos().x;
            float f2 = cardDetectionStateView2.mCardFrame.getCardNumberPos().y;
            Paint paint = cardDetectionStateView2.mCardNumberPaint;
            canvas.drawText(string3, f, f2, paint);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            CardDetectionStateView cardDetectionStateView3 = this;
            float f = cardDetectionStateView3.mCardFrame.getCardDatePos().x;
            float f3 = cardDetectionStateView3.mCardFrame.getCardDatePos().y;
            Paint paint = cardDetectionStateView3.mCardDatePaint;
            canvas.drawText(string2, f, f3, paint);
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            CardDetectionStateView cardDetectionStateView4 = this;
            float f = cardDetectionStateView4.mCardFrame.getCardHolderPos().x;
            float f4 = cardDetectionStateView4.mCardFrame.getCardHolderPos().y;
            string2 = cardDetectionStateView4.mCardHolderPaint;
            canvas.drawText(string4, f, f4, (Paint)string2);
        }
    }

    private void refreshCardRectCoords() {
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.refreshCardRectInvalidation();
        cardDetectionStateView.refreshDrawableBounds();
        cardDetectionStateView.refreshTextSize();
    }

    private void refreshCardRectInvalidation() {
        CardDetectionStateView cardDetectionStateView = this;
        Rect rect = cardDetectionStateView.mCardFrame.getCardRect();
        int n = (int)(cardDetectionStateView.mCornerPaddingLeft + 0.5f) + (int)(this.mCornerLineWidth / 2.0f + 0.5f);
        Rect rect2 = cardDetectionStateView.mCardRectInvalidation;
        rect2.left = rect.left - n;
        rect2.top = rect.top - n;
        rect2.right = rect.right + n;
        cardDetectionStateView.mCardRectInvalidation.bottom = rect.bottom + n;
    }

    private void refreshDrawableBounds() {
        CardDetectionStateView cardDetectionStateView = this;
        Rect rect = cardDetectionStateView.mCardFrame.getCardRect();
        CardDetectionStateView cardDetectionStateView2 = this;
        cardDetectionStateView2.mCardGradientDrawable.setBounds(rect);
        int n = cardDetectionStateView2.mCornerTopLeftDrawable.getIntrinsicWidth();
        int n2 = cardDetectionStateView2.mCornerTopLeftDrawable.getIntrinsicHeight();
        int n3 = (int)(cardDetectionStateView2.mCornerLineWidth / 2.0f + 0.5f);
        float f = n3;
        int n4 = Math.round((float)rect.left - this.mCornerPaddingLeft - f);
        int n5 = Math.round((float)(rect.right - n) + this.mCornerPaddingLeft + f);
        int n6 = Math.round((float)rect.top - this.mCornerPaddingTop - f);
        int n7 = Math.round((float)(rect.bottom - n2) + this.mCornerPaddingTop + f);
        int n8 = n6;
        int n9 = n4 + n;
        cardDetectionStateView.mCornerTopLeftDrawable.setBounds(n4, n8, n9, n8 + n2);
        int n10 = n6;
        int n11 = n;
        n = n5 + n;
        cardDetectionStateView.mCornerTopRightDrawable.setBounds(n5, n10, n, n10 + n11);
        int n12 = n7;
        n2 = n12 + n2;
        cardDetectionStateView.mCornerBottomLeftDrawable.setBounds(n4, n12, n9, n2);
        cardDetectionStateView.mCornerBottomRightDrawable.setBounds(n5, n7, n, n2);
        n7 = (int)cardDetectionStateView.mCornerRadius;
        BitmapDrawable bitmapDrawable = cardDetectionStateView.mLineTopDrawable;
        n9 = n4 + n7;
        n5 = n - n7;
        int n13 = n6 + bitmapDrawable.getIntrinsicHeight();
        bitmapDrawable.setBounds(n9, n6, n5, n13);
        BitmapDrawable bitmapDrawable2 = cardDetectionStateView.mLineLeftDrawable;
        int n14 = n7;
        n7 = n6 + n7;
        n6 = n2 - n14;
        bitmapDrawable2.setBounds(n4, n7, n4 += bitmapDrawable2.getIntrinsicWidth(), n6);
        BitmapDrawable bitmapDrawable3 = cardDetectionStateView.mLineRightDrawable;
        bitmapDrawable3.setBounds(n - bitmapDrawable3.getIntrinsicWidth(), n7, n, n6);
        BitmapDrawable bitmapDrawable4 = cardDetectionStateView.mLineBottomDrawable;
        bitmapDrawable4.setBounds(n9, n2 - bitmapDrawable4.getIntrinsicHeight(), n5, n2);
    }

    private void refreshTextSize() {
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mCardNumberPaint.setTextSize(this.mCardFrame.getCardNumberFontSize());
        cardDetectionStateView.mCardDatePaint.setTextSize(this.mCardFrame.getCardDateFontSize());
        cardDetectionStateView.mCardHolderPaint.setTextSize(this.mCardFrame.getCardHolderFontSize());
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        CardDetectionStateView cardDetectionStateView = this;
        super.onSizeChanged(n, n2, n3, n4);
        if (cardDetectionStateView.mCardFrame.setViewSize(n, n2)) {
            this.refreshCardRectCoords();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mCardGradientDrawable.getBounds().width() == 0) {
            return;
        }
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.drawBackground(canvas);
        cardDetectionStateView.drawCorners(canvas);
        cardDetectionStateView.drawRecognitionResult(canvas);
    }

    public synchronized void setDetectionState(int n) {
        if (this.mDetectionState != n) {
            CardDetectionStateView cardDetectionStateView = this;
            cardDetectionStateView.mDetectionState = n;
            Rect rect = cardDetectionStateView.mCardRectInvalidation;
            int n2 = rect.left;
            n = rect.top;
            int n3 = rect.right;
            int n4 = rect.bottom;
            cardDetectionStateView.postInvalidate(n2, n, n3, n4);
        }
    }

    public synchronized void setRecognitionResult(RecognitionResult recognitionResult) {
        this.mRecognitionResultCardNumber = !TextUtils.isEmpty((CharSequence)recognitionResult.getNumber()) ? CardUtils.prettyPrintCardNumber(recognitionResult.getNumber()) : null;
        this.mRecognitionResultDate = !TextUtils.isEmpty((CharSequence)recognitionResult.getDate()) ? recognitionResult.getDate().substring(0, 2) + '/' + recognitionResult.getDate().substring(2) : null;
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mRecognitionResultHolder = recognitionResult.getName();
        Rect rect = cardDetectionStateView.mCardRectInvalidation;
        int n = rect.left;
        int n2 = rect.top;
        int n3 = rect.right;
        int n4 = rect.bottom;
        cardDetectionStateView.postInvalidate(n, n2, n3, n4);
    }

    void setCameraParameters(int n, int n2, int n3, Rect rect) {
        if (this.mCardFrame.setCameraParameters(n, n2, n3, rect)) {
            CardDetectionStateView cardDetectionStateView = this;
            cardDetectionStateView.refreshCardRectCoords();
            cardDetectionStateView.invalidate();
        }
    }
}

